<?php

$default_demo_sections_st = file_get_contents('parts/default_demo_sections.json');
$GLOBALS['demo_sections'] =  json_decode($default_demo_sections_st,true);

$inner_pages = file_get_contents('../../themes/includes/inner_pages/inner_pages_sections.json');
$GLOBALS['inner_pages'] =  json_decode($inner_pages,true);

$demos_heros_and_bottoms = file_get_contents('../../themes/includes/inner_pages/inner_pages_theme_info.json');
$GLOBALS['heros_and_bottoms'] =  json_decode($demos_heros_and_bottoms,true);

$encore_setting_data = get_setting_date_from_zip();

    
$enc_setting = json_decode($encore_setting_data, true);

include "./shared/set_page_sections.php";
$enc_setting = set_page_sections_robust($enc_setting,'inner-upsilon','inner_page_1');
$enc_setting = set_page_sections_robust($enc_setting,'inner-tau','inner_page_2');
$enc_setting = set_page_sections_robust($enc_setting,'inner-iota','inner_page_3');

$enc_setting = set_page_sections_robust($enc_setting,'osaka','landing_page_1');
$enc_setting = set_page_sections_robust($enc_setting,'taipei','landing_page_2');
$enc_setting = set_page_sections_robust($enc_setting,'kyoto','landing_page_3');

$enc_setting = set_page_sections_robust($enc_setting,'product-outline-2','product_info');
$enc_setting = set_page_sections_robust($enc_setting,'inner-kappa','about');
$enc_setting = set_page_sections_robust($enc_setting,'contact-1','contact');
$enc_setting = set_page_sections_robust($enc_setting,'podcast-section','podcasts');
$enc_setting = set_page_sections_robust($enc_setting,'Store-custom','offers_page');
$enc_setting = set_page_sections_robust($enc_setting,'pricing-1','pricing');
$enc_setting = set_page_sections_robust($enc_setting,'events-2','events');
$enc_setting = set_page_sections_robust($enc_setting,'testimonials-3','testimonials');
$enc_setting = set_page_sections_robust($enc_setting,'video-testimonials-1','video_testimonials');
$enc_setting = set_page_sections_robust($enc_setting,'faq-1','faq');
$enc_setting = set_page_sections_robust($enc_setting,'gallery-masonary','gallery');
$enc_setting = set_page_sections_robust($enc_setting,'timeline-a','timeline');

$enc_current = $enc_setting["current"];

$primary_color = $enc_current["color_primary"];
$font_body = $enc_current["font_family_body"];
$color_body = $enc_current["color_body"];
$page_bg_color = $enc_current["background_color"];
$font_heading = $enc_current["font_family_heading"];
$button_bg = $enc_current["btn_background_color"];
$button_color = $enc_current["btn_text_color"];
$button_radius = $enc_current["btn_border_radius"];
$btn_style = $enc_current["btn_style"];

if(empty($page_bg_color)){
    $page_bg_color = "#ffffff";
}

$enc_current = set_login_as_dynamic($enc_setting, $enc_current);


$accent_2 = "";
if(strpos($primary_color, "(")){
    $accent_2 = rgb_to_hex( $primary_color );
    $accent_2 = adjustBrightness($accent_2, 40);
} else {
    $accent_2 = adjustBrightness($primary_color, 40);
}
if($btn_style == "outline") {
    $enc_current["p1_cta_outline"] = "true";
    $button_color = $button_bg;
}
$enc_current["paste_css"] = $enc_current["css"];
$enc_current["accent_1"] = $primary_color;
$enc_current["accent_2"] = $accent_2;
$enc_current["light_1"] = $page_bg_color;
$enc_current["light_2"] = "#f2f2f2";
$enc_current["dark_1"] = "#010101";
$enc_current["dark_2"] = "#333333";
$enc_current["text_color_dark"] = "#f2f2f2";
$enc_current["p1_cta_bg_color"] = $button_bg;
$enc_current["p1_cta_color"] = $button_color;
$enc_current["landing_pages_hero"] = "Kyoto - Hero";
$enc_current["inner_pages_hero"] = "Kyoto - Inner Hero";
$enc_current["inner_pages_bottom"] = "Kyoto - Newsletter,Kyoto - Blog";
$enc_current["p1_cta_border_radius"] = $button_radius . "px";
$enc_current["p2_cta_border_width"] = "2px";
$enc_current["license_key"] = "908a87c9ging1h24bee31";
$enc_current["css"] = "/*-- Custom Selectors --*/\n[Heading]\n.heading {\nmargin-bottom: 20px;\n}\n.heading * {\nfont-size: 36px;\nfont-weight: 400;\nline-height: 1.3;\ntext-transform: capitalize;\nmargin-top:0;\n}\n[Pre Heading]\n.pre-heading * {\nfont-size:16px;\nmargin-bottom:0;\n}\n.pre-heading {\nmargin-bottom: 10px;\n}\n[Sub Heading]\n.sub-heading {\nmargin-bottom:10px;\n}\n.sub-heading * {\nfont-size:20px;\ncolor:var(--accent-2);\n}\n/*-- Ignore --*/\n@media (max-width:767px){\n.heading * {font-size:28px;}\n}\n";


function set_login_as_dynamic($enc_setting, $enc_current) {
    if(isset($enc_setting["current"]["sections"]["login"])) {
    $login_section = $enc_setting["current"]["sections"]["login"];
    } else {
    $login_section = json_decode(get_login_if_no_login_data(), true);
    }
    $login_section_name = strval(rand(1000000000, 9999999999));
    echo $login_section_name;
    // $new_settings = json_decode($new_settings_data, true);
    $enc_current["content_for_login"] = [$login_section_name];
    $enc_current["sections"][$login_section_name] = $login_section;
    return $enc_current;

}


put_settings_data($enc_setting, $enc_current);


function get_setting_date_from_zip(){
    
    $encore_setting_data = file_get_contents("./encore_settings/settings_data_hopper.json");
    return  $encore_setting_data; 
}
function get_login_if_no_login_data(){
    
    $login_data = file_get_contents("./login.json");
    return  $login_data;
}
function put_settings_data($enc_setting, $enc_current){
    $enc_setting["current"] = array_merge($enc_setting["current"], $enc_current);
    $new_settings_data = json_encode($enc_setting);
    file_put_contents('./encore_settings_out/settings_data.json', $new_settings_data);
}

function adjustBrightness($hex, $steps) {
    // Steps should be between -255 and 255. Negative = darker, positive = lighter
    $steps = max(-255, min(255, $steps));

    // Normalize into a six character long hex string
    $hex = str_replace('#', '', $hex);
    if (strlen($hex) == 3) {
        $hex = str_repeat(substr($hex,0,1), 2).str_repeat(substr($hex,1,1), 2).str_repeat(substr($hex,2,1), 2);
    }

    // Split into three parts: R, G and B
    $color_parts = str_split($hex, 2);
    $return = '#';

    foreach ($color_parts as $color) {
        $color   = hexdec($color); // Convert to decimal
        $color   = max(0,min(255,$color + $steps)); // Adjust color
        $return .= str_pad(dechex($color), 2, '0', STR_PAD_LEFT); // Make two char hex code
    }

    return $return;
}

function rgb_to_hex( $rgba ){
    if ( strpos( $rgba, '#' ) === 0 ) {
        return $rgba;
    }

    preg_match( '/^rgba?[\s+]?\([\s+]?(\d+)[\s+]?,[\s+]?(\d+)[\s+]?,[\s+]?(\d+)[\s+]?/i', $rgba, $by_color );

    return sprintf( '#%02x%02x%02x', $by_color[1], $by_color[2], $by_color[3] );
}
