
$(document).ready(function (){
    $.getJSON('js/master_json.json?v=9',function (data) {
        MJSON_ORG = data
    }) 

    $('.bap_build_json').click(function (){
        bap_build_clicked()
    })
})



function bap_build_clicked(){
    MJSON = JSON.parse(JSON.stringify(MJSON_ORG));
    JTB_overwrite_init =   JSON.parse(JSON.stringify(JTB_overwrite))
    let new_theme = prepare_theme_json(JTB_base_theme_name,JTB_overwrite_init)
    return BAP_build(new_theme)
}

function prepare_theme_json(base_theme_name,overwrite){


    var theme_root =  MJSON.themes[base_theme_name];

    // set_static_sections
    if (overwrite.set_static_sections != undefined){
        for (key of Object.keys(overwrite.set_static_sections)){
            theme_root.current.sections[key].name = overwrite.set_static_sections[key]
        }
    }


    for (d_page of ['dashboard','post','categories','category']){


        if (d_page == 'post'){
            var dynamic_area = 'content_for_post'
            var bar_position = 'r'
            if (url_parm('ps')){
                bar_position = url_parm('ps').split('-AP')[1].substring(0,1)
                
                if(url_parm('ps').split('-RF')[1].substring(0,1) == 'f'){
                    bar_position = 'c'
                }
                if(url_parm('ps').split('-PL')[1].substring(0,1) == 'h'){
                    bar_position = 'g'
                }
                if(url_parm('ps').split('-PL')[1].substring(0,1) == 'h' && url_parm('ps').split('-RF')[1].substring(0,1) == 'f'){
                    bar_position = 's'
                }
                if(url_parm('ps').split('-AP')[1].substring(0,1) == 'h'){
                    bar_position = 'h'
                }
                if(url_parm('ps').split('-PL')[1].substring(0,1) == 'h' && url_parm('ps').split('-AP')[1].substring(0,1) == 'b'){
                    bar_position = 'b'
                }
                if(url_parm('ps').split('-PL')[1].substring(0,1) == 'h' && url_parm('ps').split('-AP')[1].substring(0,1) == 'b' && url_parm('ps').split('-RF')[1].substring(0,1) == 'f'){
                    bar_position = 'x'
                }
            }
            console.log(bar_position)
            var dyn_sections =  get_post_page_sections(bar_position)
            console.log(bar_position)
        } else {
            if (d_page == 'dashboard'){
                var dynamic_area = 'content_for_index'
                var defaults = 'vb1-lwid1-cl1-da2'
                var sections_codes =  url_parm('ds')
            }
            if (d_page == 'categories'){
                var dynamic_area = 'content_for_categories'
                var defaults = 'clh-cl5'
                var sections_codes =  url_parm('cl')
            }
            if (d_page == 'category'){
                var dynamic_area = 'content_for_category'
                var defaults = 'csh-cs1'
                var sections_codes =  url_parm('cs')
            }


            if (!(sections_codes)){
                sections_codes = defaults
            }
            console.log(dyn_sections)
            dyn_sections = []
            for (code of sections_codes.split('-')){
                dyn_sections.push(UCODE.code2sections[code])
            }
        }



        overwrite[dynamic_area] = dyn_sections

        for (i in overwrite[dynamic_area]){
            if (!(JTB_playlist_is_block) && overwrite[dynamic_area][i].includes('playlist') && !overwrite[dynamic_area][i].includes('playlist_horizontal_bg')){
                overwrite[dynamic_area][i] = JTB_playlist_name
            }   
        }
    
        JTB_append(JTB_PROGRESS_overwrites,overwrite)


        theme_root.current[dynamic_area] = overwrite[dynamic_area]
        for (section of overwrite[dynamic_area]){
            if (theme_root.current.sections[section] == undefined){
                theme_root.current.sections[section] = {}
            }
        }
    }


    theme_root.current.sections.p_header.name = JTB_header_name
    theme_root.current.sections.p_header.overwrite = JTB_header_overwrites

    for (section_name of Object.keys(overwrite.sections)){
        if (["p_header","p_main_sidebar","p_secondary_sidebar"].includes(section_name)){
            theme_root.current.sections[section_name].overwrite =  overwrite.sections[section_name]
        } else {
            let section_name_replaced = section_name.replace('|','__')
            theme_root.current.sections[section_name_replaced] =  overwrite.sections[section_name]
        } 
    }

    if (overwrite.theme_settings != undefined){
        theme_root.current.theme_settings.overwrite = overwrite.theme_settings
    }

    theme_root.current.theme_settings.overwrite = build_set_colors(theme_root.current.theme_settings.overwrite)
    
    return theme_root;
}

function build_set_colors(theme_settings){
    if (url_parm('clr')){
        let colors = url_parm('clr').split('-')
        theme_settings.accent_color_1 = '#' + colors[0]
        theme_settings.accent_color_2 = '#' + colors[1]
        theme_settings.color_bg_1 = '#' + colors[2]
        theme_settings.color_bg_2 = '#' + colors[3]
    } else {
        theme_settings.accent_color_1 = '#005ffe' 
        theme_settings.accent_color_2 = '#fadc4a' 
        theme_settings.color_bg_1 = '#f4f5fc    '
        theme_settings.color_bg_2 = '#f4f6f9'     
    }
    if (url_parm('cm') == 'd'){
        theme_settings.color_primary = '#ededed' 
        theme_settings.text_color_2 = '#ffffff'
    }
    else{
        theme_settings.color_primary = '#000000' 
        theme_settings.text_color_2 = '#777777'
    }
    return theme_settings
}

function BAP_build(theme_root){


    //  insert theme settings
    let setting_file_name = theme_root.current.theme_settings.name
    var setting_file = MJSON.themes_settings[setting_file_name];

    let attrs = theme_root.current.theme_settings.overwrite
    setting_file = overwrite_attrs(setting_file,attrs,'settings')
    
    setting_file = overwrite_buttons(setting_file)

    for (var attr_name of Object.keys(setting_file)){
        theme_root.current[attr_name] = setting_file[attr_name]
    }

    theme_root.current.color_mode = JTB_colorMode
    delete theme_root.current.theme_settings


    // insert sections
    section_id_suffix = 1
    var sections = theme_root.current.sections
    for (var section_name of Object.keys(sections)){
        if (section_name == 'undefined') { continue; }
        if (["p_header","p_main_sidebar","p_secondary_sidebar"].includes(section_name)){
           var section_data = build_section(sections[section_name].name,sections[section_name].overwrite)
            sections[section_name] = section_data
        } else {
            var section_data = build_section(section_name,sections[section_name])  
            section_name_ri = section_name.split('|')
            suffixed_name = section_name_ri[0]
            if (section_name_ri.length > 1){
                suffixed_name = section_name.replace('|','__')
                delete sections[section_name]
                //rename_in_section_order_array(section_name,suffixed_name)
            }  
            if (DEV_MODE){
             //section_data.name = DYNAMIC_SECTIONS_DASHBOARD[section_name]
            }
            sections[suffixed_name] = section_data
        }
    }


    theme_root = block_ids_to_integers(theme_root)
    theme_root = postfix_all_sections(theme_root)
    
    if (DEV_MODE){
        var theme_root_str = JSON.stringify(theme_root, null, "\t")
        save_settingsData_to_file(theme_root_str)
    } else {
       // send_to_generate_product_api(theme_root_str)
       var theme_root_str = JSON.stringify(theme_root, null)
    } 

    return  theme_root_str;
    
}


function postfix_all_sections(conf){
    var sections = conf.current.sections
    var old_section_names = []
    for (d_page of ['index','post','categories','category','announcements']){
        var postfix = 0;
        for (section_name of conf.current['content_for_'+d_page]){
            var oldName = section_name
            var newName = section_name + '_' + postfix.toString()
 
            sections[oldName].id = newName
            //let o = sections
            //delete Object.assign(o, {[newKey]: o[oldKey] })[oldKey];
            old_section_names.push(oldName)
            sections[newName] = {...sections[oldName]}
            conf.current['content_for_'+d_page][postfix] = newName

            postfix++
        }
    }
    for (old_section_name of old_section_names){
        delete sections[old_section_name]
    }

    return conf
}

function save_settingsData_to_file(theme_root_str){
    theme_root_str = theme_root_str.replace(/\: true,/g,': "true",').replace(/\: false,/g,': "false",')
    let data = {data:theme_root_str}
    $.post('../API/bap_save_settingsData.php',data,function(res){
        $('.bap_build_json').css('background-color','#0f0')
        setTimeout(function (){
            $('.bap_build_json').css('background-color','unset')
        },1000)  
    })
}

function build_section(section_name,theme_level_overwrites){
    MJSON = JSON.parse(JSON.stringify(MJSON_ORG));

    var section_name_ri = section_name.split('__')
    var section_name_without_suffix = section_name_ri[0]
    var section_name_has_suffix = false
    if (section_name_ri.length > 1){
        section_name_has_suffix = true
        section_name_suffix = section_name_ri[1]
    }
    
	var section_root = MJSON.sections[section_name_without_suffix];

    section_root = overwrite_theme_level(section_root,theme_level_overwrites)


    // insert settings
    let settings_file_name = Object.keys(section_root.settings)[0]

    let settings_file = MJSON.sections_settings[settings_file_name]
    var attrs = section_root.settings[settings_file_name]
    settings_file = overwrite_attrs(settings_file,attrs,'settings')
    
    section_root.settings = settings_file

    // insert blocks
    var block_order  = []
    for (var block_name of Object.keys(section_root.blocks)){
        if (block_name.includes('outline')){
            if (JTB_outline_name == 'Hide'){ continue }
            block_name = JTB_outline_name
            attrs = JTB_outline_overwrites
        } else if (block_name.includes('playlist') && JTB_playlist_is_block && !block_name.includes('horizontal_bar') ){
            if (JTB_playlist_name == 'playlist_none'){ continue }
            block_name = JTB_playlist_name
            attrs = JTB_playlist_overwrites
        } else {
            attrs = section_root.blocks[block_name]
        }
        let block_file = MJSON.blocks[block_name]
        
        try{
            block_file.block = overwrite_attrs(block_file.block,attrs,'block')
        } catch (e) {
            if (e instanceof TypeError ){
                alert('issue with block: ' + block_name + '\n' + 'check JTB_playlist_is_block settings')
            }
        }
        if (section_name_has_suffix){
            block_name = block_name +'__'+section_name_suffix
        }
        section_root.blocks[block_name] = block_file.block
        section_root = modify_section_clmn_settings(section_root,block_file.clmn,attrs.clmn)
        
        block_order.push(block_name)     
    }
    section_root.block_order = block_order
    return section_root;


}

function overwrite_theme_level(obj,attrs){
    for (var attr_id of Object.keys(attrs)){
        try{
            if (attr_id.includes('remove_block')){
                delete obj.blocks[attrs[attr_id]]
            }
            if (attr_id.includes('add_block')){
                obj = add_block(obj,attrs,attr_id)
            }
            var attr_id_ri =  attr_id.split('.')
            if (attr_id_ri[0] != 'settings' && attr_id_ri[0] != 'blocks'  && !(attr_id_ri[0].includes('remove_block')) && !(attr_id_ri[0].includes('add_block'))){
                alert('Theme level overwrites must begin with wither settings.* or blocks.* or remove_block')
            }
            if (attr_id_ri[0] == 'blocks'){
            obj.blocks[attr_id_ri[1]][attr_id_ri[2]] = attrs[attr_id]
            }
            if (attr_id_ri[0] == 'settings'){
                if (attr_id_ri[1] == 'padding_desktop' || attr_id_ri[1] == 'padding_mobile'){
                    attr_id_ri[1] += '.'+attr_id_ri[2]
                }
                obj.settings[Object.keys(obj.settings)[0]][attr_id_ri[1]] = attrs[attr_id]
            }
        }catch{}
    }
    if (obj.name=="Secondary Sidebar"){
         m =1
    }
    return obj
}


function add_block(obj,attrs,attr_id){
    try{
        let r1 = attrs[attr_id].split('|')
        let r2 = r1[0].split(':')
        var before_or_after = r2[0]
        var ref_block = r2[1]
        var block_to_add = r1[1]
    
        var temp = {};
        var i = 1;
        for (var prop in obj.blocks) {
            if (i == ref_block && before_or_after == 'index') {
                temp[block_to_add] = obj.blocks[prop];
            }
            if (prop == ref_block && before_or_after == 'before') {
                temp[block_to_add] = obj.blocks[prop];
            }
            temp[prop] =Object.assign({}, obj.blocks[prop]); 

            if (prop == ref_block && before_or_after == 'after') {
                temp[block_to_add] = obj.blocks[prop];
            }
            i++
        }
       
        obj.blocks = temp;
        return obj
    } catch (e) {
       alert('Error with ADD_BLOCK - required syntex: "add_block":"after:refferance_block|block_to_add"  ')   
    }
}



function overwrite_attrs(obj,attrs,type1){
    for (var attr_id of Object.keys(attrs)){
        actual_attr_id = attr_id.split('|')[0]

        if(attr_id.includes('padding_desktop') || attr_id.includes('padding_mobile')){
            let r = attr_id.split('.')
            obj[r[0]][r[1]] = attrs[attr_id]  
            return obj
        }

        if (attr_id == 'name' || type1 == 'settings' || attr_id == 'hidden'){
            var init_val = obj[actual_attr_id]
        } else {
            var init_val = obj.settings[actual_attr_id]
        }

        if (attrs[attr_id].includes('append|')){
            new_val = init_val + attrs[attr_id].replace('append|','') 
        } else if (attrs[attr_id].includes('prepend|')){ 
            new_val = attrs[attr_id].replace('prepend|','') + init_val
        } else if (attrs[attr_id].includes('replace|')){ 
            let r = attrs[attr_id].replace('replace|','').split(',')
            if (r.length == 1){ alert('use of replace| must include 2 values seprated by comma') }
            new_val = init_val.replace('replace|','').replace(r[0],r[1])
        } else {
            new_val = attrs[attr_id]  
        }

        if (attr_id == 'name' || type1 == 'settings' || attr_id == 'hidden'){
           obj[actual_attr_id] = new_val
        } else {
           obj.settings[actual_attr_id] = new_val
        }
       
    }
    return obj
}



function modify_section_clmn_settings(section_root,clmn_settings,new_clmn){
    if (clmn_settings == undefined){ return section_root; }
    
    for (var clmn_attr of Object.keys(clmn_settings)){
        section_root.settings[clmn_attr+'_'+new_clmn] = clmn_settings[clmn_attr]
    }
    return section_root
}



 function block_ids_to_integers(conf){
   var sections_j = conf.current.sections
   for (var section_name of Object.keys(sections_j)){
       for (var i in sections_j[section_name].block_order){
           var oldKey = sections_j[section_name].block_order[i]
           var newKey = getRandomId()
           sections_j[section_name].block_order[i] = newKey.toString()
           let o = sections_j[section_name].blocks
           delete Object.assign(o, {[newKey]: o[oldKey] })[oldKey];
       }
       
   }
   return conf
}


function getRandomId(){
   return  99999999999 + Math.floor(Math.random() * 99999999999);
}

function overwrite_buttons(setting_file){
    if (url_parm('b')){
        var btns = 'btn_' + url_parm('b')
    }  else {
        var btns = 'btn_d1'
    }
    var bjson = MJSON_ORG.sections[btns]
    for (item of bjson){
        let key = item.id.replace('settings_','') 
        setting_file[key] = item.val
    }
    return setting_file 
}