

console.log('Dynamic Sections')


$(document).ready(function (){

    $( ".dynamic_sections_wrap_inner" ).sortable({
        update: function( event, ui ) {
            
            setTimeout(function (){
                ds_scroll_to_section(ui.item.attr('d_id'))
            },200)
            reorder_dynamic_sections()
        }
    });

    set_add_section_items()

    $('.dynamic_sections_add').click(function (){
        $('.r2_sidebar').addClass('with_account_page')
        account_page_show('add_section')
        if ($('.add_section_page_content > div').length == 0){
            add_sections_to_add_page()
        }        
    })

    $('body').on('click','.add_this_section',function (){
        $('.r2_sidebar').removeClass('with_account_page')
        add_dynamic_setion($(this).attr('did'))
        account_page_hide('add_section')
        scroll_to_new_section() 
    })


    $('.dynamic_sections_add_popup_close').click(function (){
        $('.dynamic_sections_add_popup').hide()
    })

    $('body').on('click','.dynamic_sections_item_remove',function (){
        remove_dynamic_section($(this))
    }) 

    $('.add_section_page_back, .add_section_page_close').click(function (){
        $('.r2_sidebar').removeClass('with_account_page')
        account_page_hide('add_section')
    })

    $('body').on('click','.dynamic_sections_item_wrap',function (){
        ds_scroll_to_section($(this).attr('d_id'));
    }) 
    
    $('body').on('change','.dynamic_sections_presets',function (){
        dynamic_sections_presets($(this).val())
    }) 
    
})

function dynamic_sections_presets(val){
    if (val == 'select'){ return }
    $('.dynamic_sections_wrap_inner').html('')
    $('div[data-content-for-index]').html('')
    for (section of val.split('-')){
       add_dynamic_section_helper(UCODE.code2sections[section])
    }
    $('.jarallax').jarallax({speed: 0.2});
    DEMO['sections'] = list_dnamic_sections();
    set_url()
}

function reorder_dynamic_sections(){
    var dynamic_area = get_dynamic_section_wrap()

    var sections_obj = {}
    $('div['+dynamic_area+'] div[data-section-id]').each(function (){
        sections_obj[$(this).attr('d_id')] = $(this)
    })

    $('div['+dynamic_area+']').html('')
    var new_order = []
    $('.dynamic_sections_item_wrap').each(function (){
        let d_id = $(this).attr('d_id')
        $('div['+dynamic_area+']').append(sections_obj[d_id])
    })

    DEMO['sections'] = list_dnamic_sections();
    set_url()
}

function set_add_section_items(){
    if (PAGE == 'post'){
        var items = DYNAMIC_SECTIONS_POST
    } else {
        var items = DYNAMIC_SECTIONS_DASHBOARD
    }
    
    var $select = $('.dynamic_sections_add_popup select')
    var st = ''
    for (key of Object.keys(items)){
        if (key == undefined){ continue;}
        st = '<option value="'+items[key]+'">'+key+'</option>'
        $select.append(st)
    }
}

d_id_cnt = 20
function add_dynamic_setion(val){
    $('.dynamic_sections_add_popup').hide()
    d_id_cnt++
    //var val = $('.dynamic_sections_add_popup select').val()
    add_dynamic_section_helper(val)
    $('.jarallax').jarallax({speed: 0.2});

    DEMO['sections'] = list_dnamic_sections();
    set_url()
}

function add_dynamic_section_helper(val){
    let d_id = val + '|' + d_id_cnt
    let st =`<div class="dynamic_sections_item_wrap" d_id="`+d_id+`">
                <span>`+DYNAMIC_SECTIONS_DASHBOARD[val]+`</span>              
                <div class="dynamic_sections_item_icons">
                    <div class="dynamic_sections_item_remove"><svg xmlns="http://www.w3.org/2000/svg" width="14.517" height="16" viewBox="0 0 14.517 16">
                    <g id="Group_936" data-name="Group 936" transform="translate(-184.246 -778.25)">
                      <path id="Vector" d="M14,2.96c-1.2-.119-2.4-.208-3.6-.275V2.678l-.164-.967C10.126,1.027,9.963,0,8.222,0H6.273C4.54,0,4.376.982,4.257,1.7L4.1,2.656c-.692.045-1.384.089-2.075.156L.508,2.96a.557.557,0,1,0,.1,1.108L2.13,3.92A59.305,59.305,0,0,1,13.9,4.076h.06a.563.563,0,0,0,.558-.506A.57.57,0,0,0,14,2.96Z" transform="translate(184.246 778.25)" fill="#ff5858"/>
                      <path id="Vector-2" data-name="Vector" d="M11.01.29A.94.94,0,0,0,10.333,0H.931A.928.928,0,0,0,.254.29.958.958,0,0,0,0,.989L.463,8.621c.082,1.131.186,2.544,2.782,2.544H8.02c2.6,0,2.7-1.406,2.782-2.544L11.263,1A.964.964,0,0,0,11.01.29ZM6.867,7.438H4.39a.558.558,0,0,1,0-1.116H6.867a.558.558,0,0,1,0,1.116Zm.625-2.975H3.773a.558.558,0,1,1,0-1.116H7.492a.558.558,0,1,1,0,1.116Z" transform="translate(185.869 783.085)" fill="#ff5858"/>
                    </g>
                  </svg>
                  </div>
                    <div class="dynamic_sections_item_handle"><i class="fas fa-bars"></i></div>
                </div>
            </div>`
    $('.dynamic_sections_wrap_inner').append(st)
    
    
    let html_text = replace_before_adding_section(MHTML.sections[val])

    let $new_section = $(html_text)
    $new_section.attr('d_id',d_id)

    $new_section = jarallax_fix($new_section)

    $new_section = replace_dynamic_section_block_ids($new_section)
    $('div[data-content-for-index]').append($new_section)
}

function replace_before_adding_section(text){
    if(text == undefined){ return }
  //  $section = str_replace('42isirdu7n','c1ludijve5',$section);
  text = text.replace(/42isirdu7n/g,'c1ludijve5')
  text = text.replace(/rykrvj3o6k/g,'c1ludijve5')
  text = text.replace('There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration.','Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed eiusmod tempor incididunt ut labore et dolor.')
  text = text.replace("Lorem ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s.",'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Non blandit massa enim nec.')
  text = text.replace("Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s.",'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Non blandit massa enim nec.')
  text = text.replace("Contrary to popular belief, Lorem ipsum is not",'Lorem ipsum dolor sit amet, consectetur elit.')
  text = text.replace("Contrary to popular belief",'Lorem ipsum dolor sit amet')
  text = text.replace(/is simply dummy text of the printing and typesetting industry/g,'consectetur adipiscing elit, sed do eiusmod tempor incididunt')
  text = text.replace(/simply dummy text of the printing and typesetting/g,'consectetur adipiscing elit, sed do eiusmod tempor')
  text = text.replace(/simply dummy text/g,'do eiusmod tempor')
  text = text.replace("New post 31",'Lorem ipsum amet')
  text = text.replace(/yaron zeltzer/g,'Jeff Ipsum')

  text = text.replace("Membership Sample course",'Learn How to Ipsum')
  
  

  
  return text
}

function jarallax_fix($new_section){
    if ($new_section.find('.jarallax') != 0){
        $new_section.find('.jarallax').attr('style','') 
        $new_section.find('div[id*="jarallax-container"]').remove()
    }
    return $new_section
}

function get_dynamic_section_wrap(){
    if (PAGE == 'dashboard'){
        return 'data-content-for-index'
    }
    if (PAGE == 'post'){
        return 'data-content-for-post'
    }
}

function remove_dynamic_section($this){
    let section_d_id = $this.closest('.dynamic_sections_item_wrap').attr('d_id')
    $this.closest('.dynamic_sections_item_wrap').remove()
    $('div[d_id="'+section_d_id+'"]').remove()

    DEMO['sections'] = list_dnamic_sections();
    set_url()
}

function list_dnamic_sections(){
    var r = []
    $('.dynamic_sections_item_wrap').each(function (){
        let d_id = $(this).attr('d_id')
        let sname = d_id.split('|')[0]
        r.push(UCODE.sections2code[sname])
    })
    return r.join('-')
}


function add_sections_to_add_page(){
    var $all = $('<div class="add_sec_inner"></div>')
    var items = DYNAMIC_SECTIONS_DASHBOARD
    for (key of Object.keys(DYNAMIC_SECTIONS_DASHBOARD)){
        if (key == undefined) {break}
        let $new_section = $(MHTML.sections[key])
        $new_section = replace_dynamic_section_block_ids($new_section)
        $new_section = replace_wistia_ids($new_section)
        let m = '<div class="add_this_section" did="'+key+'">Add Section</div>'
        $new_section.prepend(m)
        $all.append($new_section)
    }
    $('.add_section_page_content').append($all)
}

function replace_wistia_ids($new_section){
    if ($new_section.find('.wistia_embed').length != 0) {
        let w_id = $new_section.find('.wistia_embed').attr('id') + getRandomId
        $new_section.find('.wistia_embed').attr('id',w_id)
    }
    return $new_section
}


function scroll_to_new_section(){
    $scroll_elm = $('.page_wrap')
    if ($('.p_contant_out').css('overflow-y') == 'scroll'){
        $scroll_elm = $('.p_contant_out')
    }

    $scroll_elm[0].scrollTo(0,0)
    setTimeout(function (){
        let offset = $('div[data-content-for-index] > div:nth-last-child(1)')[0].offsetTop
        //$('.page_wrap')[0].scrollTo(0,offset,{behavior: 'smooth'})
        $scroll_elm.animate({scrollTop:offset},'50');

        $section_drag_box = $('.dynamic_sections_wrap_inner .dynamic_sections_item_wrap:nth-last-child(1)')
        $section_drag_box.css('background-color','#004CFF')
        setTimeout(function (){
            $section_drag_box.css('background-color','#f0eeee')
            setTimeout(function (){
                $section_drag_box.css('background-color','#004CFF')
                setTimeout(function (){
                    $section_drag_box.css('background-color','unset')
                },1000)
            },1000)
        },1000)


    },1000)

}


function ds_scroll_to_section(d_id){
    $scroll_elm = $('.page_wrap')
    if ($('.p_contant_out').css('overflow-y') == 'scroll'){
        $scroll_elm = $('.p_contant_out')
    }
    let offset = $('.main-content div[d_id="'+d_id+'"]')[0].offsetTop
    $scroll_elm.animate({scrollTop:offset},200);
}