
function load_default_sections(){
    reset_JTB()
    
    if (PAGE == 'dashboard'){
        dashboard_default_layout()
    } 
    if (PAGE == 'post'){
        post_discovery_vertical_playlist()
    } 
    set_layout_and_playlist_to_default()
    
    //post_sidebar()
}

function reset_JTB(){
    JTB_base_theme_name = 'base_theme'
    JTB_playlist_is_block = false
    JTB_overwrite = {
        "set_static_sections":{},
        "sections":{}
    }
}


function change_layout(val){
    set_layout_defaults()
    reset_JTB()
    set_layout_and_playlist_to_default()
    window[val]();
    
}

function change_post_layout(val){
    window[val]();
    
}


function set_header(section_name,header_type){
    let text = replace_before_adding_section(MHTML.sections[section_name])
    $('#section-p_header').replaceWith(text)
    JTB_header_name = section_name
}

function set_mainBar(section_name){
    let text = replace_before_adding_section(MHTML.sections[section_name])
    $('.main_sidebar_wrap').html(text)

    JTB_overwrite.set_static_sections = {
        "p_main_sidebar":section_name
    }
}
function set_secondBar(section_name){
    let text = replace_before_adding_section(MHTML.sections[section_name])
    $('#section-p_secondary_sidebar').replaceWith(text)

    JTB_overwrite.set_static_sections = {
        "p_secondary_sidebar":section_name
    }
}



function set_layout_defaults(){
    $('.p_wrap_out').replaceWith(PRODUCT_LAYOUT)
    //set_colors('#005ffe','#fadc4a','','','#F4F5FC','#FFFFFF','','','#000000','#161515')
}

console.log('layout_helpers')


function change_outline(selected_outlnie){
    if (selected_outlnie == 'Hide'){
        $(".nblock-outline").hide()
        $('.block-1637908664883').hide()
        $('.block-1645169001417').hide()
        $('.block-1637908664883').parent(".section-clmn-1").hide()
        //  add json  remove block 
        JTB_outline_overwrites = {
            "hidden":"true"
        }
        let append_obj = ''
        
        if($('.section').has('#block-1637908664883').length !== 0 ){
            append_obj = {
                "sections": {
                    "p_secondary_sidebar": {
                        "remove_block": "secondary_sidebar_evolution_1_heading",
                        "settings.clmn_style_1": "replace|/* -- Desktop Style --*/,/* -- Desktop Style --*/\nmin-height: 0;"
                    }
                }
            }
        }

        JTB_append(append_obj,JTB_overwrite)
    } else {
        $('.block-1637908664883').parent(".section-clmn-1").show()
        $('.block-1637908664883').show()
        $('.block-1645169001417').show()
        $('.nblock-outline').replaceWith(MHTML.blocks[selected_outlnie])
        JTB_outline_name = selected_outlnie
    }

    //collapse_outline($('.selects_outline_collpase').val())
}

function sec_type(type){
    if (type == "dis1") {
        set_secondBar('secondary_sidebar_discovery_1')
      } else if(type == "dis2"){
        set_secondBar('secondary_sidebar_discovery_2')
      } else if(type == "dis3"){
        set_secondBar('secondary_sidebar_discovery_3')
      }else if(type == "dis4"){
        set_secondBar('secondary_sidebar_discovery_4')
      }else if(type == "dis5"){
        set_secondBar('secondary_sidebar_discovery_5')
      }else if(type == "dis6"){
        set_secondBar('secondary_sidebar_discovery_6')
      }else {
        set_secondBar('secondary_sidebar_evolution_1')
        change_outline('outline_evolution_2')
        $('.select_outline').val('outline_evolution_2')
      }
    console.log(type)
}

function set_layout_and_playlist_to_default(){
    JTB_PROGRESS_overwrites = {}
    let fist_val = $('.select_outline option:nth-child(1)').attr('value')
    $('.select_outline').val(fist_val)
    JTB_outline_name = fist_val
    JTB_outline_overwrites = {}
    fist_val = $('.select_playlist option:nth-child(1)').attr('value')
    $('.select_playlist').val(fist_val)
    JTB_playlist_name = fist_val
    JTB_playlist_overwrites = {}
    fist_val = $('.select_header option:nth-child(1)').attr('value')
    $('.select_header').val(fist_val)
    JTB_header_name = fist_val
    JTB_header_overwrites = {}

    fist_val = $('.select_color_mode option:nth-child(1)').attr('value')
    $('.select_color_mode').val(fist_val)
    JTB_colorMode  = 'White Mode'
    set_rgba_vars()

    $('.dynamic_styles,.progress_styles').html('')
    $('.background-theme-image-top,.background-theme-image-bottom,.main-content').attr('style','')
    $('.background-theme-image-top .nimage,.background-theme-image-bottom .nimage').attr('src','')
    $('body').attr('class','')

    $('.content_top_padding input').val('0')

}





function hide_mainBar(){
    //html
    hide_mainBar_html()

   //json
   if (JTB_overwrite['sections'] == undefined){
    JTB_overwrite['sections'] = {}
    }
    JTB_overwrite.sections["p_main_sidebar"] = {
        "settings.show_sidebar_dashboard":"false",
        "settings.show_sidebar_post":"false"
    }
    if (JTB_overwrite['theme_settings'] == undefined){
        JTB_overwrite['theme_settings'] = {}
    }
    JTB_overwrite.theme_settings["content_width"] = "1352px"
}

function hide_mainBar_html(){
    //html
   $('.main_sidebar_wrap').hide()
   $('.main-content-spacer, #section-p_header .sizer ').css('max-width','1352px').css('margin','0 auto')
   $('.toggle-sidebar').hide()
   $('.p_wrap_out').removeClass('show_main_sidebar').removeClass('main_sidebar_position-Left').removeClass('main_sidebar_position-Right')

}




function set_content_sections(sections,skip_sortable_items){
    $('div[data-content-for-index]').html('')
    if (!skip_sortable_items){
        $('.dynamic_sections_wrap_inner').html('')
    }
    var cnt = 1
    var d_id = ''
    var section_ri = []
    var section_name = ''
    for (section of sections){
        d_id = section
        section_name = section
        section_ri = section.split('|')
         if (section_ri.length > 1){
            section_name = section_ri[0]
        }
        
        let text = MHTML.sections[section_name]
        text = text.replace(/rykrvj3o6k/g,'c1ludijve5')
        text = text.replace(/yaron zeltzer/g,'Jeff Lorem')

        let $new_section = $(text)
        $new_section = replace_dynamic_section_block_ids($new_section)
        $new_section.attr('d_id',section)
        $('div[data-content-for-index]').append($new_section)

        if (!skip_sortable_items){
            
            let st =`<div class="dynamic_sections_item_wrap" d_id="`+d_id+`">
                        <span>`+section_name+`</span>              
                        <div class="dynamic_sections_item_icons">
                        <div class="dynamic_sections_item_remove"><svg xmlns="http://www.w3.org/2000/svg" width="14.517" height="16" viewBox="0 0 14.517 16">
                        <g id="Group_936" data-name="Group 936" transform="translate(-184.246 -778.25)">
                          <path id="Vector" d="M14,2.96c-1.2-.119-2.4-.208-3.6-.275V2.678l-.164-.967C10.126,1.027,9.963,0,8.222,0H6.273C4.54,0,4.376.982,4.257,1.7L4.1,2.656c-.692.045-1.384.089-2.075.156L.508,2.96a.557.557,0,1,0,.1,1.108L2.13,3.92A59.305,59.305,0,0,1,13.9,4.076h.06a.563.563,0,0,0,.558-.506A.57.57,0,0,0,14,2.96Z" transform="translate(184.246 778.25)" fill="#ff5858"/>
                          <path id="Vector-2" data-name="Vector" d="M11.01.29A.94.94,0,0,0,10.333,0H.931A.928.928,0,0,0,.254.29.958.958,0,0,0,0,.989L.463,8.621c.082,1.131.186,2.544,2.782,2.544H8.02c2.6,0,2.7-1.406,2.782-2.544L11.263,1A.964.964,0,0,0,11.01.29ZM6.867,7.438H4.39a.558.558,0,0,1,0-1.116H6.867a.558.558,0,0,1,0,1.116Zm.625-2.975H3.773a.558.558,0,1,1,0-1.116H7.492a.558.558,0,1,1,0,1.116Z" transform="translate(185.869 783.085)" fill="#ff5858"/>
                        </g>
                      </svg>
                      </div>
                        <div class="dynamic_sections_item_handle"><i class="fas fa-bars"></i></div>
                            </div>
                    </div>`
            $('.dynamic_sections_wrap_inner').append(st)
        }
        cnt++
    }


    //json
    if (PAGE == 'dashboard'){
        var dynamic_key = "content_for_index"
    } 
    if (PAGE == 'post'){
        var dynamic_key = "content_for_post"
    } 
    if (PAGE == 'categories'){
        var dynamic_key = "content_for_categories"
    } 
    JTB_overwrite[dynamic_key] = sections
}

function set_select_options(selector,options){
    $(selector).html('')
    for (option of options){
        $(selector).append('<option value="'+option[0]+'">'+option[1]+'</option>')
    }
}

function replace_dynamic_section_block_ids($section){
    randPostfix = 99999 + Math.floor(Math.random() * 99999);
    $section.find('.nblock').each(function (){
        block_id = $(this).attr('id')
        if ($(this).hasClass('nblock-container')){
            return true   
        }
        new_block_id =  block_id + '_' + randPostfix
        $(this).find('style').each(function (){
            var style_st = $(this).html()
            var re_block_id = new RegExp(block_id,"g");
            style_st = style_st.replace(re_block_id,new_block_id)
            $(this).html(style_st)
        })
        $(this).attr('id',new_block_id) 
    })

    return $section
}
//

function change_color_mode(val){
    var accent1 = getComputedStyle(document.documentElement).getPropertyValue('--accent-color-1');
    var accent2 = getComputedStyle(document.documentElement).getPropertyValue('--accent-color-2');

    if (val == 'Light'){
        set_colors(accent1,accent2,'','','#F4F5FC','#FFFFFF','','','#000000','#161515')
        $('body').removeClass('dark')
        JTB_colorMode = 'White Mode'
    }
    if (val == 'Dark'){
        set_colors(accent1,accent2,'','','#141313','#1F1F1F','','','#FFFFFF','#F2F2F2')   
        $('body').addClass('dark')
        JTB_colorMode = 'Dark Mode'
    }
}


function set_colors(accent1,accent2,accent3,accent4,bg1,bg2,bg3,bg4,text1,text2){
    set_css_var('--accent-color-1',accent1)
    set_css_var('--accent-color-2',accent2)
    set_css_var('--accent-color-3',accent3)
    set_css_var('--accent-color-4',accent4)
    set_css_var('--bg-color-1',bg1)
    set_css_var('--bg-color-2',bg2)
    set_css_var('--bg-color-3',bg3)
    set_css_var('--bg-color-4',bg4)
    set_css_var('--text-color-1',text1)
    set_css_var('--text-color-2',text2)

    DEMO.colors = accent1.replace('#','') + '-' + accent2.replace('#', '') + '-' + bg1.replace('#', '') + '-' + bg2.replace('#', '')
    set_rgba_vars()


}
function set_css_var(name,val){
    document.querySelector(':root').style.setProperty(name, val);
}

function JTB_append(append_obj,obj2overWrite){ 
    JTB_append_helper(append_obj,obj2overWrite,"theme_settings")
    JTB_append_helper(append_obj,obj2overWrite,"sections")
    if (append_obj.sections == undefined){return}
    for (k of Object.keys(append_obj.sections)){
        JTB_append_helper(append_obj.sections,obj2overWrite.sections,k)
    }
}

function JTB_append_helper(append_obj,obj2overWrite,parent_key){
    if(append_obj[parent_key] != undefined){
        if(obj2overWrite[parent_key] == undefined){
            obj2overWrite[parent_key] = append_obj[parent_key]
        } else {
            for (child_key of Object.keys(append_obj[parent_key])){
                if (parent_key == 'sections' && obj2overWrite[parent_key][child_key] != undefined){continue}
                obj2overWrite[parent_key][child_key] = append_obj[parent_key][child_key]
            }
        }
    }
}

function background_images(top_img,top_height,bottom_img,bottom_height){
    $('.background-theme-image-top img').attr('src',top_img)
    $('.background-theme-image-bottom img').attr('src',bottom_img)
    $('.background-theme-image-top').css('height',top_height)
    $('.background-theme-image-bottom').css('height',bottom_height)
    $('.background-theme-image-top').attr('style','display: block; height:'+ top_height)
    if(bottom_height != ''){
        $('.background-theme-image-bottom').attr('style','display: block; height:'+ bottom_height)
    }
    if (JTB_overwrite['theme_settings'] == undefined){
        JTB_overwrite['theme_settings'] = {}
    }
    JTB_overwrite.theme_settings["show_theme_top_image"] = "true"
    JTB_overwrite.theme_settings["theme_top_image"] = top_img
    JTB_overwrite.theme_settings["top_image_height"] = top_height
    JTB_overwrite.theme_settings["show_theme_bottom_image"] = "true"
    JTB_overwrite.theme_settings["theme_bottom_image"] = bottom_img
    JTB_overwrite.theme_settings["bottom_image_height"] = bottom_height
}

function content_top_bottom_padding(top,bottom){
    $('.main-content').css('padding-bottom',bottom)
    if($('.content_top_padding input').val() > 0){
        top = $('.content_top_padding input').val()
    }
    if(bottom){
        var st = `
        @media(max-width: 768px){
            .main-content{
                padding-bottom: 20px !important;
            }
        }
        `
        $('.dynamic_styles').append(st);
    }
    
    changeContentPadding(parseInt(top))

    if (JTB_overwrite['theme_settings'] == undefined){
        JTB_overwrite['theme_settings'] = {}
    }
    // JTB_overwrite.theme_settings['content_top_padding'] = top
    JTB_overwrite.theme_settings['content_bottom_padding'] = bottom
}

function hexToRgb(hex) {
    var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
    return result ? parseInt(result[1], 16) + ',' + parseInt(result[2], 16) + ',' + parseInt(result[3], 16) : null;
}
SIX_COLORS = '--accent-1,--accent-2,--light-1,--light-2,--dark-1,--dark-2'
function set_rgba_vars(){
    root = document.documentElement;
    for (item of SIX_COLORS.split(',')){
        let val = getComputedStyle(document.documentElement).getPropertyValue(item);
        var rgb_val = hexToRgb(val.trim());
        if (val.includes('rgb')){
            rgb_val_r = val.replace(')','').replace('rgb(','').replace('rgba(','').trim().split(',')
            rgb_val = rgb_val_r[0]+','+rgb_val_r[1]+','+rgb_val_r[2]
        }
        root.style.setProperty(item+'-rgb',rgb_val );
    }
}


function change_padding_to_30(){ 
    $('.content .section').each(function(){
        var p = $(this)[0]
        var style = p.currentStyle || window.getComputedStyle(p);
        console.log(style.marginLeft)
        if (style.marginLeft == '20px'){
            $(this).css('margin-left','30px').css('margin-right','30px')
        }
    })
}


function show_pmaster_lables(val){
    console.log(val)
    $('.pmaster_label').remove()
    if (!val){ return } 
    $('section').each(function (){
        let iname = $(this).data('iname').replace(/ /g,'_')
        let st = show_pmaster_helper(iname)
        $(this).prepend(st)
    })
    let st = show_pmaster_helper(JTB_outline_name)
    $('.nblock-outline').prepend(st)
    st = show_pmaster_helper(JTB_playlist_name)
    $('.nblock-outline').prepend(st)

}
function show_pmaster_helper(name){
    try{
        let r = PMASTER[name].split(',')
        let preview_url =  'https://kajabi-themes.mykajabi.com/products/'+r[2]+'?preview_theme_id='+r[3]
        let edit_url =  'https://app.kajabi.com/admin/themes/'+r[3]+'/settings/edit'
        return st = '<div class="pmaster_label"><a target="_blank" href="'+preview_url+'">'+name+' </a><a href="'+edit_url+'" target="_blank" class="pmaster_label_edit">Edit</a></div>'
    } catch (e) {
    }
   
}