console.log('build_settingsData')

MJSON_ORG = {}
MJSON = {}
JTB_overwriteInit = {}

class Build{

    constructor(){
        this.getMJSON()
        this.events()
    }

    getMJSON(){
        var url = 'https://dev.robust-themes.com/njs/master_json.json?v=1.4'
        if (isR2){
            url = ASSETS_PATH+'master_json.js?v=1.4'
        }
        $.getJSON(url,function (data) {
            MJSON_ORG = data
        }) 
    }

    events(){
        $('.bap_build_json').click(function (){
            ROUTER.loadUrl()
            BUILD.bapBuildClicked()
        })
    }

    bapBuildClicked(){
        // JTB_overwrite.setStaticSections["post_completion"] = "completion_message"
        MJSON = JSON.parse(JSON.stringify(MJSON_ORG));
        JTB_overwriteInit =   JSON.parse(JSON.stringify(JTB_overwrite))
        console.log(JTB_overwrite)
        let newTheme = this.prepareThemeJson(JTB_baseThemeName,JTB_overwriteInit)
        var settingsData = this.BAPbuild(newTheme)
        console.log(settingsData)
        return settingsData
    
        
    }
    
    prepareThemeJson(baseThemeName,overwrite){
        var themeRoot =  MJSON.themes[baseThemeName];

        // setStaticSections
        if (overwrite.setStaticSections != undefined){
            for (var key of Object.keys(overwrite.setStaticSections)){
                themeRoot.current.sections[key].name = overwrite.setStaticSections[key]
            }
        }
    
        for (var dPage of ['dashboard','post','categories','category','search']){
    
            if (dPage == 'post'){
                // PAGE = 'post'
                // console.log(PAGE)
                // POST.updatePostSettings()
                var dynamicArea = 'content_for_post'
                var dynSections =  POST.postPageSections()
            } else {
                if (dPage == 'dashboard'){
                    var dynamicArea = 'content_for_index'
                    var defaults = 'vb1-lwid1-cl1-da2'
                    var sectionsCodes =  ROUTER.urlParm('ds')
                }
                if (dPage == 'categories'){
                    var dynamicArea = 'content_for_categories'
                    var defaults = 'clh-cl5'
                    var sectionsCodes =  ROUTER.urlParm('cl')
                }
                if (dPage == 'category'){
                    var dynamicArea = 'content_for_category'
                    var defaults = 'csh-cs1'
                    var sectionsCodes =  ROUTER.urlParm('cs')
                }
                if (dPage == 'search'){
                    var dynamicArea = 'content_for_search'
                    var defaults = 'lsh-lf1'
                    var sectionsCodes =  ROUTER.urlParm('sh')
                }
                if(dPage == "announcments"){
                    var dynamicArea = 'content_for_announcements'
                    var defaults = 'a1-a3'
                    var sectionsCodes =  ROUTER.urlParm('an')
                }
                if (!(sectionsCodes)){
                    sectionsCodes = defaults
                }
                console.log(dynSections)
                dynSections = []
                for (var code of sectionsCodes.split('-')){
                    var section_name = UCODE.code2sections[code]

                    if (dPage == 'search'){
                        if (section_name.includes('lesson_search') ||  section_name.includes('lesson_filters_')){
                            section_name = section_name + '_static'
                        }
                    }

                    dynSections.push(section_name)
                }
            }
    
    
    
            overwrite[dynamicArea] = dynSections
    
            for (var i in overwrite[dynamicArea]){
                if (!(JTB_playlistIsBlock) && overwrite[dynamicArea][i].includes('playlist') && !overwrite[dynamicArea][i].includes('playlist_horizontal_bg')){
                    overwrite[dynamicArea][i] = JTB_playlistName
                }   
            }
        
            LAYOUT.JTB_append(JTB_ProgressOverwrites,overwrite)
            LAYOUT.JTB_append(JTB_BadgeOverwrites,overwrite)
    
    
            themeRoot.current[dynamicArea] = overwrite[dynamicArea]
            for (var section of overwrite[dynamicArea]){
                if (themeRoot.current.sections[section] == undefined){
                    themeRoot.current.sections[section] = {}
                }
            }
        }
    
    
        themeRoot.current.sections.p_header.name = JTB_headerName
        themeRoot.current.sections.p_header.overwrite = JTB_headerOverwrites
    
        for (var sectionName of Object.keys(overwrite.sections)){
            if (["p_header","p_main_sidebar","p_secondary_sidebar", "p_badges"].includes(sectionName)){
                themeRoot.current.sections[sectionName].overwrite =  overwrite.sections[sectionName]
            } else {
                let sectionNameReplaced = sectionName.replace('|','__')
                themeRoot.current.sections[sectionNameReplaced] =  overwrite.sections[sectionName]
            } 
        }
    
        if (overwrite.theme_settings != undefined){
            themeRoot.current.theme_settings.overwrite = overwrite.theme_settings
        }
    
        themeRoot.current.theme_settings.overwrite = this.buildSetColors(themeRoot.current.theme_settings.overwrite)
        
        return themeRoot;
    }
    
    buildSetColors(themeSettings){
        if (ROUTER.urlParm('clr')){
            let colors = ROUTER.urlParm('clr').split('-')
            themeSettings.accent_color_1 = '#' + colors[0]
            themeSettings.accent_color_2 = '#' + colors[1]
            themeSettings.color_bg_1 = '#' + colors[2]
            themeSettings.color_bg_2 = '#' + colors[3]
        } else {
            themeSettings.accent_color_1 = '#005ffe' 
            themeSettings.accent_color_2 = '#fadc4a' 
            themeSettings.color_bg_1 = '#f4f5fc    '
            themeSettings.color_bg_2 = '#f4f6f9'     
        }
        if (ROUTER.urlParm('cm') == 'd'){
            themeSettings.color_primary = '#ededed' 
            themeSettings.text_color_2 = '#ffffff'
        }
        else{
            themeSettings.color_primary = '#000000' 
            themeSettings.text_color_2 = '#777777'
        }
        return themeSettings
    }
    
    BAPbuild(themeRoot){
    
        //  insert theme settings
        let settingFileName = themeRoot.current.theme_settings.name
        var settingFile = MJSON.themes_settings[settingFileName];
    
        let attrs = themeRoot.current.theme_settings.overwrite
        settingFile = this.overwriteAttrs(settingFile,attrs,'settings')
        
        settingFile = this.overwriteButtons(settingFile)
    
        for (var attrName of Object.keys(settingFile)){
            themeRoot.current[attrName] = settingFile[attrName]
        }
    
        themeRoot.current.color_mode = COLORS.JTB_colorMode
        delete themeRoot.current.theme_settings
    
    
        // insert sections
        var sections = themeRoot.current.sections
        for (var sectionName of Object.keys(sections)){
            if (sectionName == 'undefined') { continue; }
            if (["p_header","p_main_sidebar","p_secondary_sidebar", "p_badges"].includes(sectionName)){
               var sectionData = this.buildSection(sections[sectionName].name,sections[sectionName].overwrite)
                sections[sectionName] = sectionData
            } else {
                var sectionData = this.buildSection(sectionName,sections[sectionName])  
                var sectionNameRi = sectionName.split('|')
                var suffixedName = sectionNameRi[0]
                if (sectionNameRi.length > 1){
                    suffixedName = sectionName.replace('|','__')
                    delete sections[sectionName]
                }  

                if (suffixedName.includes('lesson_search') ||  suffixedName.includes('lesson_filters_')){
                   // let sname = suffixedName + '_static' 
                   // sections[sname] = sectionData
                   // sections[sname].id = sname
                } 

                sections[suffixedName] = sectionData
            }
        }
    
        themeRoot = this.blockIdsToIntegers(themeRoot)
        
        var themeRootStr = JSON.stringify(themeRoot, null)
        return  themeRootStr;
        
    }
    
    buildSection(sectionName,themeLevelOverwrites){
        MJSON = JSON.parse(JSON.stringify(MJSON_ORG));
    
        var sectionNameRi = sectionName.split('__')
        var sectionNameWithoutSuffix = sectionNameRi[0]
        var sectionNameHasSuffix = false
        if (sectionNameRi.length > 1){
            sectionNameHasSuffix = true
            sectionNameSuffix = sectionNameRi[1]
        }

        let section_id = sectionNameWithoutSuffix
        if (sectionNameWithoutSuffix.includes('lesson_search') ||  sectionNameWithoutSuffix.includes('lesson_filters_')){
            sectionNameWithoutSuffix = sectionNameWithoutSuffix.replace('_static','')
        } 
        
        var sectionRoot = MJSON.sections[sectionNameWithoutSuffix];
        sectionRoot.id = section_id
    
        sectionRoot = this.overwriteThemeLevel(sectionRoot,themeLevelOverwrites)
    
    
        // insert settings
        let settingsFileName = Object.keys(sectionRoot.settings)[0]
    
        let settingsFile = MJSON.sections_settings[settingsFileName]
        var attrs = sectionRoot.settings[settingsFileName]
        settingsFile = this.overwriteAttrs(settingsFile,attrs,'settings')
        
        sectionRoot.settings = settingsFile
    
        // insert blocks
        var blockOrder  = []
        for (var blockName of Object.keys(sectionRoot.blocks)){
            if (blockName.includes('outline')){
                if (JTB_outlineName == 'Hide'){ continue }
                blockName = JTB_outlineName
                attrs = JTB_outlineOverwrites
            } else if (blockName.includes('playlist') && JTB_playlistIsBlock && !blockName.includes('horizontal_bar') ){
                if (JTB_playlistName == 'playlist_none'){ continue }
                blockName = JTB_playlistName
                attrs = JTB_playlistOverwrites
            } else {
                attrs = sectionRoot.blocks[blockName]
            }
            let blockFile = MJSON.blocks[blockName]
            
            try{
                blockFile.block = this.overwriteAttrs(blockFile.block,attrs,'block')
            } catch (e) {
                if (e instanceof TypeError ){
                    alert('issue with block: ' + blockName + '\n' + 'check JTB_playlistIsBlock settings')
                }
            }
            if (sectionNameHasSuffix){
                blockName = blockName +'__'+sectionNameSuffix
            }
            sectionRoot.blocks[blockName] = blockFile.block
            sectionRoot = this.modifySectionClmnSettings(sectionRoot,blockFile.clmn,attrs.clmn)
            
            blockOrder.push(blockName)     
        }
        sectionRoot.block_order = blockOrder
        return sectionRoot;
    
    
    }
    
    overwriteThemeLevel(obj,attrs){
        for (var attrId of Object.keys(attrs)){
            try{
                if (attrId.includes('remove_block')){
                    delete obj.blocks[attrs[attrId]]
                }
                if (attrId.includes('add_block')){
                    obj = this.addBlock(obj,attrs,attrId)
                }
                var attrIdRi =  attrId.split('.')
                if (attrIdRi[0] != 'settings' && attrIdRi[0] != 'blocks'  && !(attrIdRi[0].includes('remove_block')) && !(attrIdRi[0].includes('add_block'))){
                    console.warn('Theme level overwrites must begin with wither settings.* or blocks.* or remove_block')
                }
                if (attrIdRi[0] == 'blocks'){
                obj.blocks[attrIdRi[1]][attrIdRi[2]] = attrs[attrId]
                }
                if (attrIdRi[0] == 'settings'){
                    if (attrIdRi[1] == 'padding_desktop' || attrIdRi[1] == 'padding_mobile'){
                        attrIdRi[1] += '.'+attrIdRi[2]
                    }
                    obj.settings[Object.keys(obj.settings)[0]][attrIdRi[1]] = attrs[attrId]
                }
            }catch{}
        }

        return obj
    }
    
    addBlock(obj,attrs,attrId){
        try{
            let r1 = attrs[attrId].split('|')
            let r2 = r1[0].split(':')
            var beforeOrAfter = r2[0]
            var refBlock = r2[1]
            var blockToAdd = r1[1]
        
            var temp = {};
            var i = 1;
            for (var prop in obj.blocks) {
                if (i == refBlock && beforeOrAfter == 'index') {
                    temp[blockToAdd] = obj.blocks[prop];
                }
                if (prop == refBlock && beforeOrAfter == 'before') {
                    temp[blockToAdd] = obj.blocks[prop];
                }
                temp[prop] =Object.assign({}, obj.blocks[prop]); 
    
                if (prop == refBlock && beforeOrAfter == 'after') {
                    temp[blockToAdd] = obj.blocks[prop];
                }
                i++
            }
           
            obj.blocks = temp;
            return obj
        } catch (e) {
           alert('Error with ADD_BLOCK - required syntex: "add_block":"after:refferance_block|block_to_add"  ')   
        }
    }
    
    overwriteAttrs(obj,attrs,type1){
        for (var attrId of Object.keys(attrs)){
            var actualAttrId = attrId.split('|')[0]
    
            if(attrId.includes('padding_desktop') || attrId.includes('padding_mobile')){
                let r = attrId.split('.')
                obj[r[0]][r[1]] = attrs[attrId]  
                return obj
            }
    
            if (attrId == 'name' || type1 == 'settings' || attrId == 'hidden'){
                var initVal = obj[actualAttrId]
            } else {
                var initVal = obj.settings[actualAttrId]
            }
    
            if (attrs[attrId].includes('append|')){
                var newVal = initVal + attrs[attrId].replace('append|','') 
            } else if (attrs[attrId].includes('prepend|')){ 
                var newVal = attrs[attrId].replace('prepend|','') + initVal
            } else if (attrs[attrId].includes('replace|')){ 
                let r = attrs[attrId].replace('replace|','').split(',')
                if (r.length == 1){ alert('use of replace| must include 2 values seprated by comma') }
                var newVal = initVal.replace('replace|','').replace(r[0],r[1])
            } else {
                var newVal = attrs[attrId]  
            }
    
            if (attrId == 'name' || type1 == 'settings' || attrId == 'hidden'){
               obj[actualAttrId] = newVal
            } else {
               obj.settings[actualAttrId] = newVal
            }
           
        }
        return obj
    }
    
    modifySectionClmnSettings(sectionRoot,clmnSettings,newClmn){
        if (clmnSettings == undefined){ return sectionRoot; }
        
        for (var clmn_attr of Object.keys(clmnSettings)){
            sectionRoot.settings[clmn_attr+'_'+newClmn] = clmnSettings[clmn_attr]
        }
        return sectionRoot
    }
    
    
     blockIdsToIntegers(conf){
       var sectionsJ = conf.current.sections
       for (var section_name of Object.keys(sectionsJ)){
           for (var i in sectionsJ[section_name].block_order){
               var oldKey = sectionsJ[section_name].block_order[i]
               var newKey = this.getRandomId()
               sectionsJ[section_name].block_order[i] = newKey.toString()
               let o = sectionsJ[section_name].blocks
               delete Object.assign(o, {[newKey]: o[oldKey] })[oldKey];
           }
           
       }
       return conf
    }
    
    getRandomId(){
       return  99999999999 + Math.floor(Math.random() * 99999999999);
    }
    
    overwriteButtons(settingFile){
        if (ROUTER.urlParm('b')){
            var btns = 'btn_' + ROUTER.urlParm('b')
        }  else {
            var btns = 'btn_d1'
        }
        var bjson = MJSON_ORG.sections[btns]
        for (var item of bjson){
            let key = item.id.replace('settings_','') 
            settingFile[key] = item.val
        }
        return settingFile 
    }
}

