console.log('colors.js')
console.log('colors.js222')
//


class Colors{

    constructor(){
        this.cssVarsValues = [];
        this.pallete_selected = false
        this.six_colors = '--accent-color-1,--accent-color-2,--bg-color-1,--bg-color-2'
        this.palletes = PALLETES_light
        this.pickers = {}
        this.JTB_colorMode = 'White Mode'

        this.colorsOnload()
    }

    colorsOnload(){
        
        for (var item of this.six_colors.split(',')){
            let val = getComputedStyle(document.documentElement).getPropertyValue(item);
            this.cssVarsValues[item.replace('--','')] = val
            $('.tp_colors  li[data-color="'+item+'"] div').css('background-color',val)
        }
        
        this.intiatePickers()
        this.createColorPalettes()
        this.loadUrlColorMode()
        this.events()
    }


    events(){
        $('body').on('click','.pickr',function(){
            let item = $(this).closest('li').data('color');
            COLORS.pickers[item].show()
        });
    
        $('body').on('click','.topbar_color_palette',function(){
            let index = $(this).data('index')
            COLORS.paletteSelected(COLORS.palletes[index].colors)
            ROUTER.setUrl();
        })
        
        $('.cb_color_mode > div').click(function(){
            $('.cb_color_mode > div').removeClass('active')
            $(this).addClass('active')
            COLORS.colorModeClicked($(this).text())
        })
    }


    loadUrlColorMode(){
        if(IsR2){
            DEMO['colorMode'] = ROUTER.urlParm('cm')
        }
        var colorMode = DEMO.colorMode
        this.changeColorMode('Light')
        this.palletes = PALLETES_light
        this.createColorPalettes()
        DEMO.colorMode = 'l'
        $('.cb_color_mode > div').removeClass('active')
        $('.cb_color_mode > .u_left').addClass('active')
        if (colorMode){
            if (colorMode == 'd'){
                this.changeColorMode('Dark')
                this.palletes = PALLETES_dark
                this.createColorPalettes()
                DEMO.colorMode = 'd'
                $('.cb_color_mode > div').removeClass('active')
                $('.cb_color_mode > .u_right').addClass('active')
            }
        }
    }

    loadUrlColors(){
        var colors = ROUTER.urlParm('clr')
        if (colors){
                DEMO.colors = colors
                let palette  = colors.split('-')
                for (var i in palette){
                    palette[i] = '#'+palette[i]
                }
                this.paletteSelected(palette)

                let colorsR = colors.split('-')
                this.setColors(colorsR[0], colorsR[1], colorsR[2], colorsR[3], colorsR[4], colorsR[5])
        } else {
            this.setColors('#005ffe', '#fadc4a', '#F4F5FC', '#FFFFFF', '#000000', '#777777')
        }
    }

    colorModeClicked(mode){

        this.changeColorMode(mode)

        var accent1 = getComputedStyle(document.documentElement).getPropertyValue('--accent-color-1').replace('#','');
        var accent2 = getComputedStyle(document.documentElement).getPropertyValue('--accent-color-2').replace('#','');
        DEMO.colors = accent1 + '-' + accent2 + '-'
        DEMO['color-mode'] = {}
        
        if (mode == 'Dark'){
            this.palletes = PALLETES_dark
            var bg1 = '141313'
            var bg2 = '1F1F1F'
            DEMO.colorMode = 'd'
        } else {
            this.palletes = PALLETES_light
            var bg1 = 'F4F5FC'
            var bg2 = 'FFFFFF'
            DEMO.colorMode = 'l'
        }

        DEMO.colors += bg1 + '-' + bg2
        $('.tp_colors  li[data-color="--bg-color-1"] div').css('background-color','#'+bg1)
        $('.tp_colors  li[data-color="--bg-color-2"] div').css('background-color','#'+bg2)
        this.setCssVar('--bg-color-1','#'+bg1)
        this.setCssVar('--bg-color-2','#'+bg2)
        this.pickers["--bg-color-1"].setColor('#'+bg1)
        this.pickers["--bg-color-2"].setColor('#'+bg2)
        this.createColorPalettes()

        TOPBAR.changed('colors')
        ROUTER.setUrl()
    }
    
    intiatePickers(){
        for (var item of this.six_colors.split(',')){
            this.pickers[item] = Pickr.create({
                el: '.tp_colors  li[data-color="'+item+'"] div',
                theme: 'classic',
                default: this.cssVarsValues[item.replace('--','')].trim(),
                item:item,
                components: {
                    preview: true, opacity: true, hue: true,
                    interaction: {
                        hex: true, rgba: true, input: true, save: true , cancel: true
                    }
                }
            });
            this.pickers[item].on('save', (color, instance) => {
                instance.hide()
                if (!this.pallete_selected){
                    this.getVarColorsAndsetUrl()
                }
                this.pallete_selected = false
    
            })
            this.pickers[item].on('change', (color,eventSource, instance) => {
                let item = instance.options.item
                this.setColorVar(item,color)
            })
            this.pickers[item].on('hide', ( instance) => {
                let item = instance.options.item
                let color = instance.getSelectedColor()
                this.setColorVar(item,color)
            })
            this.pickers[item].on('cancel', ( instance) => {
                let item = instance.options.item
                let color = instance.getSelectedColor()
                this.setColorVar(item,color)
                instance.hide()
            })    
        }
    }
    
    setColorVar(item,color){
        var color_val = color.toRGBA().toString(0).replace(/ /g,'')
        let alpha = color.toRGBA()[3]
        if ( alpha == 1){
            color_val = color.toHEXA().toString()
        }
        console.log(color_val)
        document.querySelector(':root').style.setProperty(item, color_val);
        let c = color.toRGBA().toString(0).replace(')','').replace('rgba(','').split(',')
        console.log(c)
        let rgb = c[0]+','+c[1]+','+c[2]
        document.querySelector(':root').style.setProperty(item+ '-rgb', rgb);
    
        this.cssVarsValues[item.replace('--','')] = color_val
    }
    
    paletteSelected(palette){
        var i = 0;
        var  demoColors = [];
        for (var item of this.six_colors.split(',')){
            let val = palette[i]
            $('.tp_colors  li[data-color="'+item+'"] div').css('background-color',val)
            this.pallete_selected = true;
            this.pickers[item].setColor(val)
            document.querySelector(':root').style.setProperty(item, val);
            document.querySelector(':root').style.setProperty(item+ '-rgb', this.hexToRgb(val));
            demoColors.push(val.replace('#',''))
            this.cssVarsValues[item.replace('--','')] = val
            i++;
        }
        DEMO.colors = demoColors.join('-')
    
        TOPBAR.changed('colors')
    }
    
    
    getVarColorsAndsetUrl(){
        var  demoColors = [];
        for (var item of this.six_colors.split(',')){
            let val = getComputedStyle(document.documentElement).getPropertyValue(item);
            demoColors.push(val.trim().replace('#','').replace(/,/g,'|'))
        }
        DEMO.colors = demoColors.join('-')
    
        ROUTER.setUrl();
        TOPBAR.changed('colors')
    
    }
    
    
    createColorPalettes(){
        $('.tp_color_palletes_wrap').html('')
        for (var x=0;x<this.palletes.length;x++ ){
            let $wrap = $('<div class="color_2 swiper-slide"></div>')
            var newPalleteHtml = this.createApallete(this.palletes[x],x)
            $wrap.append(newPalleteHtml)
            x++;
            newPalleteHtml = this.createApallete(this.palletes[x],x)
            $wrap.append(newPalleteHtml)
            $('.tp_color_palletes_wrap').append($wrap)
            colorsSwiper.update()
        }
    }
    
    
    createApallete(palette,index){
        var palleteTemplate =`
        <div class="tp_pallete_item_wrap">
            <div class="tp_pallete_name">{name}</div>
            <div class="topbar_color_palette" data-index="{index}"> 
                <div class="cb_palette_colors cb_palette_accent">
                <div><div class="cb-pal-box brl" data-color="--accent-1" style="background-color:1"></div><span>{=1}</span></div>
                <div><div class="cb-pal-box" data-color="--accent-2" style="background-color:2"></div><span>{=2}</span></div>
                </div>
                <div class="cb_palette_colors cb_palette_bg">
                <div><div class="cb-pal-box" data-color="--light-1" style="background-color:3"></div>
                <div><div class="cb-pal-box brr" data-color="--light-2" style="background-color:4"></div></div>
    
                </div>
            </div>
        </div>`
    
        var colors_ri = palette.colors
        palleteTemplate = palleteTemplate.replace('{index}',index)
        palleteTemplate = palleteTemplate.replace('{name}',palette.name)
        for(i=1;i<this.palletes.length;i++){
            let re = new RegExp(':'+i,"g");
            palleteTemplate = palleteTemplate.replace(re,':'+colors_ri[i-1])
            let re1 = new RegExp('{='+i+'}', "g")
            if(colors_ri[i-1]){
                palleteTemplate = palleteTemplate.replace(re1,colors_ri[i-1])
            } else{
                palleteTemplate = palleteTemplate.replace(re1,'')
            }
            
        }
        return palleteTemplate;
    
    }
        
    hexToRgb(hex) {
        var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
        return result ? parseInt(result[1], 16) + ',' + parseInt(result[2], 16) + ',' + parseInt(result[3], 16) : null;
    }

    setRgbaVars(){
        var root = document.documentElement;
        for (var item of this.six_colors.split(',')){
            let val = getComputedStyle(document.documentElement).getPropertyValue(item);
            var rgbVal = this.hexToRgb(val.trim());
            if (val.includes('rgb')){
                rgbVal = val.replace(')','').replace('rgb(','').replace('rgba(','').trim().split(',')
                rgbVal = rgbVal[0]+','+rgbVal[1]+','+rgbVal[2]
            }
            root.style.setProperty(item+'-rgb',rgbVal );
        }
    }


    changeColorMode(val){
        var accent1 = getComputedStyle(document.documentElement).getPropertyValue('--accent-color-1');
        var accent2 = getComputedStyle(document.documentElement).getPropertyValue('--accent-color-2');
        var bg1 = getComputedStyle(document.documentElement).getPropertyValue('--bg-color-1');
        var bg2 = getComputedStyle(document.documentElement).getPropertyValue('--bg-color-2');
        accent1 = accent1.padStart(6, '0')
        accent2 = accent2.padStart(6, '0')
        bg1 = bg1.padStart(6, '0')
        bg2 = bg2.padStart(6, '0')
        if (val == 'Light'){
            this.setColors(accent1,accent2,bg1,bg2,'#000000','#161515')
            $('body').removeClass('dark')
            this.JTB_colorMode = 'White Mode'
        }
        if (val == 'Dark'){
            this.setColors(accent1,accent2,bg1,bg2,'#FFFFFF','#F2F2F2')   
            $('body').addClass('dark')
            this.JTB_colorMode = 'Dark Mode'
        }
    }


    setColors(accent1,accent2,bg1,bg2,text1,text2){
        accent1 = accent1.trim().padStart(6, '0')
        accent2 = accent2.trim().padStart(6, '0')
        bg1 = bg1.trim().padStart(6, '0')
        bg2 = bg2.trim().padStart(6, '0')
        this.setCssVar('--accent-color-1',accent1)
        this.setCssVar('--accent-color-2',accent2)
        this.setCssVar('--bg-color-1',bg1)
        this.setCssVar('--bg-color-2',bg2)
        this.setCssVar('--text-color-1',text1)
        this.setCssVar('--text-color-2',text2)

        DEMO.colors = accent1.replace('#','') + '-' + accent2.replace('#', '') + '-' + bg1.replace('#', '') + '-' + bg2.replace('#', '')
        this.setRgbaVars()
    }
    
    setCssVar(name,val){
        if (val == undefined || val == ''){return}
        if (!val.includes('#') && !val.includes('rgb')){
            if (val.includes('rgb')){
                val = val.replace(/|/g,',')
            }
            val = '#'+val
        }
        document.querySelector(':root').style.setProperty(name, val);
    }

}



