console.log('Dynamic Sections')

class DynamicSections {

    constructor() {
        this.dIdCnt = 20
        this.events()
        if(IsR2){
            this.sortSections()
            $('body').on('click','.dynamic_sections_item_remove',function (){
                DYNAMIC_SECTIONS.remove_dynamic_section($(this))
            }) 
            $('.dynamic_sections_add').click(function (){
                TOPBAR.collapseTopbar()
                $('.r2_sidebar').addClass('with_account_page')
                account_page_show('add_section')
                if ($('.add_section_page_content > div').length == 0){
                    DYNAMIC_SECTIONS.add_sections_to_add_page()
                }
                $(".account_page.add_section").css('margin-top', $(".r2_topbar").css("height"))
                
            })
            $('body').on('click','.add_this_section',function (){
                $('.r2_sidebar').removeClass('with_account_page')
                DYNAMIC_SECTIONS.addDynamicSection($(this).attr('did'))
                account_page_hide('add_section')
                DYNAMIC_SECTIONS.scroll_to_new_section() 
            })
            $('.add_section_page_back, .add_section_page_close').click(function (){
                $('.r2_sidebar').removeClass('with_account_page')
                account_page_hide('add_section')
            })
            $('body').on('click','.add_section_categories > div', function(){
                $('.add_section_categories > div').removeClass('active')
                $(this).addClass('active')
                DYNAMIC_SECTIONS.loadSection(POST_SECTIONS[$(this).data('key')])
            })
        }
    }

    events() {
        $('.r3_sections_wrapper > div').click(function () {
            $('.apply_button').removeClass('disab')
            console.log('sections')
            DYNAMIC_SECTIONS.dynamicSectionsPresets($(this).data('value'))
        })
    }
    sortSections(){
        $( ".dynamic_sections_wrap_inner" ).sortable({
            update: function( event, ui ) {
                setTimeout(function (){
                    DYNAMIC_SECTIONS.dsScrollToSection(ui.item.attr('d_id'))
                },200)
                DYNAMIC_SECTIONS.reorderDynamicSection()
            }
        });
    }
    dsScrollToSection(d_id){
        var $scroll_elm = $('.page_wrap')
        if ($('.p_contant_out').css('overflow-y') == 'scroll'){
            $scroll_elm = $('.p_contant_out')
        }
        let offset = $('.main-content div[d_id="'+d_id+'"]')[0].offsetTop
        $scroll_elm.animate({scrollTop:offset},200);
    }
    addDynamicSection(val){
        $('.dynamic_sections_add_popup').hide()
        this.dIdCnt++
        //var val = $('.dynamic_sections_add_popup select').val()
        this.addDynamicSectionHelper(val)
        $('.jarallax').jarallax({speed: 0.2});
    
        DEMO['sections'] = this.list_dnamic_sections();
        ROUTER.setUrl()
    }
    reorderDynamicSection(){
        var dynamic_area = this.get_dynamic_section_wrap()
    
        var sections_obj = {}
        $('div['+dynamic_area+'] div[data-section-id]').each(function (){
            sections_obj[$(this).attr('d_id')] = $(this)
        })
    
        $('div['+dynamic_area+']').html('')
        var new_order = []
        $('.dynamic_sections_item_wrap').each(function (){
            let d_id = $(this).attr('d_id')
            $('div['+dynamic_area+']').append(sections_obj[d_id])
        })
    
        DEMO['sections'] = this.list_dnamic_sections();
        ROUTER.setUrl()
    }
    get_dynamic_section_wrap(){
        if (PAGE == 'dashboard'){
            return 'data-content-for-index'
        }
        if (PAGE == 'post'){
            return 'data-content-for-post'
        }
    }
    list_dnamic_sections(){
        var r = []
        $('.dynamic_sections_item_wrap').each(function (){
            let d_id = $(this).attr('d_id')
            let sname = d_id.split('|')[0]
            r.push(UCODE.sections2code[sname])
        })
        return r.join('-')
    }
    add_sections_to_add_page(){
        $('.add_section_categories').html('')
        var categories = POST_SECTIONS.categories
        for(var key of Object.keys(categories)){
            var list = `<div data-key="${categories[key]}"><i class="${PRODUCT_CATEGORY_ICONS[categories[key]]}"></i><span>${categories[key]}</span></div>`
            $('.add_section_categories').append(list)
        }
        this.loadSection(POST_SECTIONS['Banners'])
        $('.add_section_categories div[data-key="Banners"]').addClass('active')
    }
    loadSection(sectionNames){
        var wrapper = $('.add_section_content')
        wrapper.html('')
        for(var sectionName of sectionNames){
            var newSection = $(MHTML.sections[sectionName])
            newSection = LAYOUT.replaceDynamicSectionBlockIds(newSection)
            newSection = DYNAMIC_SECTIONS.replace_wistia_ids(newSection)
            var sectionTitle = PRODUCT_SECTIONS_NAMES[sectionName]
            let m = '<div class="add_section_header_wrapper"><div class="add_section_name">'+sectionTitle+'</div><div class="add_this_section" did="'+sectionName+'"><span>Add Section</span><i class="far fa-plus"></i></div></div>'
            newSection.prepend(m)
            wrapper.append(newSection)
        }
        $(".add_section_header_wrapper").parent().css("width", "100%")
        $('.add_section_content').scrollTop(0)
    }
    replace_wistia_ids($new_section){
        /*
        if ($new_section.find('.wistia_embed').length != 0) {
            let w_id = $new_section.find('.wistia_embed').attr('id') + Math.floor(Math.random() * 9999)
            $new_section.find('.wistia_embed').attr('id',w_id)
        }*/
        return $new_section
    }
    dynamicSectionsPresets(val) {
        if (val == 'select') { return }
        $('.dynamic_sections_wrap_inner').html('')
        $('div[data-content-for-index]').html('')
        for (var section of val.split('-')) {
            this.addDynamicSectionHelper(UCODE.code2sections[section])
        }
        $('.jarallax').jarallax({ speed: 0.2 });
        DEMO['sections'] = val;
        ROUTER.setUrl()
        TOPBAR.changed('dynamic_sections')
    }
    
    remove_dynamic_section($this){
        let section_d_id = $this.closest('.dynamic_sections_item_wrap').attr('d_id')
        $this.closest('.dynamic_sections_item_wrap').remove()
        $('div[d_id="'+section_d_id+'"]').remove()
    
        DEMO['sections'] = this.list_dnamic_sections();
        ROUTER.setUrl()
    }

    addDynamicSectionHelper(val) {
        let dId = val + '|' + this.dIdCnt
        if(IsR2){
            let st = `<div class="dynamic_sections_item_wrap" d_id="` + dId + `">
            <span>`+ DYNAMIC_SECTIONS_DASHBOARD[val] + `</span>              
            <div class="dynamic_sections_item_icons">
                <div class="dynamic_sections_item_remove"><svg xmlns="http://www.w3.org/2000/svg" width="14.517" height="16" viewBox="0 0 14.517 16">
                <g id="Group_936" data-name="Group 936" transform="translate(-184.246 -778.25)">
                  <path id="Vector" d="M14,2.96c-1.2-.119-2.4-.208-3.6-.275V2.678l-.164-.967C10.126,1.027,9.963,0,8.222,0H6.273C4.54,0,4.376.982,4.257,1.7L4.1,2.656c-.692.045-1.384.089-2.075.156L.508,2.96a.557.557,0,1,0,.1,1.108L2.13,3.92A59.305,59.305,0,0,1,13.9,4.076h.06a.563.563,0,0,0,.558-.506A.57.57,0,0,0,14,2.96Z" transform="translate(184.246 778.25)" fill="#ff5858"/>
                  <path id="Vector-2" data-name="Vector" d="M11.01.29A.94.94,0,0,0,10.333,0H.931A.928.928,0,0,0,.254.29.958.958,0,0,0,0,.989L.463,8.621c.082,1.131.186,2.544,2.782,2.544H8.02c2.6,0,2.7-1.406,2.782-2.544L11.263,1A.964.964,0,0,0,11.01.29ZM6.867,7.438H4.39a.558.558,0,0,1,0-1.116H6.867a.558.558,0,0,1,0,1.116Zm.625-2.975H3.773a.558.558,0,1,1,0-1.116H7.492a.558.558,0,1,1,0,1.116Z" transform="translate(185.869 783.085)" fill="#ff5858"/>
                </g>
              </svg>
              </div>
                <div class="dynamic_sections_item_handle"><i class="fas fa-bars"></i></div>
            </div>
        </div>`
            $('.dynamic_sections_wrap_inner').append(st)
        }
        let htmlText = this.replaceBeforeAddingSection(MHTML.sections[val])
        let $newSection = $(htmlText)
        $newSection.attr('d_id', dId).attr('not-dirty', 'true')

        $newSection = this.jarallaxFix($newSection)

        $newSection = LAYOUT.replaceDynamicSectionBlockIds($newSection)
        $('div[data-content-for-index]').append($newSection)
    }

    replaceBeforeAddingSection(text) {
        text = text.replace(/42isirdu7n/g,'c1ludijve5')
        text = text.replace(/rykrvj3o6k/g, 'c1ludijve5')
        text = text.replace(/7zaabl7v7i/g, 'c1ludijve5')
        
        text = text.replace('There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration.', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed eiusmod tempor incididunt ut labore et dolor.')
        text = text.replace("Lorem ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s.", 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Non blandit massa enim nec.')
        text = text.replace("Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s.", 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Non blandit massa enim nec.')
        text = text.replace("Contrary to popular belief, Lorem ipsum is not", 'Lorem ipsum dolor sit amet, consectetur elit.')
        text = text.replace("Contrary to popular belief", 'Lorem ipsum dolor sit amet')
        text = text.replace(/is simply dummy text of the printing and typesetting industry/g, 'consectetur adipiscing elit, sed do eiusmod tempor incididunt')
        text = text.replace(/simply dummy text of the printing and typesetting/g, 'consectetur adipiscing elit, sed do eiusmod tempor')
        text = text.replace(/simply dummy text/g, 'do eiusmod tempor')
        text = text.replace("New post 31", 'Lorem ipsum amet')
        text = text.replace(/yaron zeltzer/g, 'Jeff Ipsum')
        text = text.replace("Membership Sample course", 'Learn How to Ipsum')
        text = text.replace(/kjb-settings-id/g, 'kjb-settings-disabled')
        text = text.replace(/clmn_show_grids-true/g, '')
        return text
    }

    jarallaxFix($newSection) {
        if ($newSection.find('.jarallax') != 0) {
            $newSection.find('.jarallax').attr('style', '')
            $newSection.find('div[id*="jarallax-container"]').remove()
        }
        return $newSection
    }
    scroll_to_new_section(){
        var $scroll_elm = $('.page_wrap')
        if ($('.p_contant_out').css('overflow-y') == 'scroll'){
            $scroll_elm = $('.p_contant_out')
        }
    
        $scroll_elm[0].scrollTo(0,0)
        setTimeout(function (){
            let offset = $('div[data-content-for-index] > div:nth-last-child(1)')[0].offsetTop
            //$('.page_wrap')[0].scrollTo(0,offset,{behavior: 'smooth'})
            $scroll_elm.animate({scrollTop:offset},'50');
    
            $section_drag_box = $('.dynamic_sections_wrap_inner .dynamic_sections_item_wrap:nth-last-child(1)')
            $section_drag_box.css('background-color','#004CFF')
            setTimeout(function (){
                $section_drag_box.css('background-color','#f0eeee')
                setTimeout(function (){
                    $section_drag_box.css('background-color','#004CFF')
                    setTimeout(function (){
                        $section_drag_box.css('background-color','unset')
                    },1000)
                },1000)
            },1000)
    
    
        },1000)
    
    }

}

