class Features {
    constructor(){
        this.events()
        this.getSectionsFromUrl()
        this.sortTabs()
        this.addClasstoTabs()
        this.syncKajabiTabs()
    }
    events(){
        $(".feature_posts > div").on("click", function(){
            FEATURES.changeSectionStyle($(this))
            ROUTER.setUrl()
        })
        $(".feature_tabs > div").click(function(){
            FEATURES.changeTabs($(this))
        })
        $("body").on("click", ".use-post-section > input", function(e){
            e.stopPropagation()
            if($(this).is(":checked")){
                $(this).closest(".post-section-sort").removeClass("post-disabled")
            } else {
                $(this).closest(".post-section-sort").addClass("post-disabled")
            }
            FEATURES.reorderPostSections()
            ROUTER.setUrl()
            FEATURES.changeSections()
            // FEATURES.getSectionsFromUrl()
            // var sections = POST.postPageSections()
            // LAYOUT.setContentSections(sections)
            // FEATURES.reorderPostSections()
        })
    }
    syncKajabiTabs(){
        var sections = []
        if(window.location.href.includes('kajabi.com')){
            $(`.features_tabs_sections .post-section-sort`).addClass("post-disabled")
            $(`.features_tabs_sections`).append($(`.features_tabs_sections .post-section-sort`).detach())
            $(`.features_tabs_sections .post-section-sort input`).prop("checked", false)
            $('.content section').each(function(){
                var sectionName = $(this).data('iname')
                    sectionName = sectionName.replace(/ /g, "_")
                    sections.push(sectionName)
                    $(`.features_tabs_sections`).append($(`.features_tabs_sections div[data-name="${sectionName}"]`).detach())
                    $(`.features_tabs_sections div[data-name="${sectionName}"] input`).prop("checked", true)
                    $(`.features_tabs_sections div[data-name="${sectionName}"]`).removeClass("post-disabled")
                
            })
            if($("section[data-iname='post media discovery v1'] section").hasClass("card_sections")){
                $(".feature_posts > div").removeClass("active")
                $(".feature_tabs > div[value='card']").addClass("active")
            } else{
                $(".feature_tabs > div[value='normal']").addClass("active")
            }
            if($(".tabs-wrapper").length){
                $(".post-tab:not(.mobile_only)").each(function(){
                    var tabSections = $(this).data("for")
                    var sectionName = $(`#section-${tabSections} section`).data('iname').replace(/ /g, "_")
                    $(`.post_tabs_sortable`).append($(`.features_tabs_sections div[data-name="${sectionName}"]`).detach())
                })
                if($("section[data-type='post_tabs']").hasClass("hidden--mobile")){
                    $(".feature_tabs > div").removeClass("active")
                    $(".feature_tabs > div[value='desktop_only']").addClass("active")
                }
            } else{
                $(".feature_tabs > div").removeClass("active")
                $(".feature_tabs > div[value='disable_tabs']").addClass("active")
                $(".post_tabs_wrapper").addClass("post-disabled").hide()
            }
            console.log(sections)
        }
    }
    postSectionsSelected(tabs, sections){
        DEMO.postTabs = tabs
        DEMO.postSections = sections
        ROUTER.setUrl()
        this.getSectionsFromUrl()
        // var sections = POST.postPageSections()
        // LAYOUT.setContentSections(sections)
        // this.reorderPostSections()
        this.changeSections()
    }
    changeSections(){
        var barPosition = "r"
        var playList = "d"
        var sidebBarStyle = "r"
        if(DEMO.postSettings){
            playList = DEMO.postSettings.match(/PL./)[0].split('PL')[1]
            barPosition = DEMO.postSettings.match(/AP./)[0].split('AP')[1]
            sidebBarStyle = DEMO.postSettings.match(/RF./)[0].split('RF')[1]
        }
        POST.postActionBarPosition(UCODE.code2pBarPosition[barPosition])
        POST.postSidebarStyle(sidebBarStyle)
        POST.changePlaylist(UCODE.code2playlist[playList])
        TOPBAR.changed('change_post_layout')
    }
    getSectionsFromUrl(){
        var sbText = ROUTER.urlParm('pl')
        if(sbText){
            $(`.features_tabs_sections .post-section-sort`).addClass("post-disabled")
            $(`.features_tabs_sections`).append($(`.features_tabs_sections .post-section-sort`).detach())
            $(`.features_tabs_sections .post-section-sort input`).prop("checked", false)
            DEMO.postSections = sbText
            for (var item of sbText.split('-')){
                $(`.features_tabs_sections`).append($(`.features_tabs_sections div[data-name="${UCODE.code2psection[item]}"]`).detach())
                console.log(UCODE.code2psection[item])
                $(`.features_tabs_sections div[data-name="${UCODE.code2psection[item]}"] input`).prop("checked", true)
                $(`.features_tabs_sections div[data-name="${UCODE.code2psection[item]}"]`).removeClass("post-disabled")
            }
        }
        var tabSections = ROUTER.urlParm('pt')
        if(tabSections){
            DEMO.postTabs = tabSections
            for(var item of tabSections.split("-")){
                if(item == "th"){
                    DEMO.showTabSection = false
                    $(".feature_tabs > div").removeClass('active')
                    $(".feature_tabs > div[value='disable_tabs']").addClass("active")
                    $(".post_tabs_wrapper").addClass("post-disabled").hide()
                } else if(item == "ds"){
                    DEMO.showTabSection = "desktop"
                    $(".feature_tabs > div").removeClass('active')
                    $(".feature_tabs > div[value='desktop_only']").addClass("active")
                } 
                else{
                    DEMO.showTabSection = true
                    $(".feature_tabs > div").removeClass('active')
                    $(".feature_tabs > div[value='enable_tabs']").addClass("active")
                    $(".post_tabs_wrapper").removeClass("post-disabled").show()
                }
                $(`.post_tabs_sortable`).append($(`.features_tabs_sections div[data-name="${UCODE.code2psection[item]}"]`).detach())
            }
        }
        var sectionStyle = ROUTER.urlParm('ts')
        if(sectionStyle){
            DEMO.postSectionStyle = sectionStyle
            $(".feature_posts > div").removeClass('active')
            if(sectionStyle == "c"){
                $(".feature_posts > div[value='card']").addClass('active')
            } else{
                $(".feature_posts > div[value='normal']").addClass('active')
            }
            this.changeSectionStyle($(".feature_posts > div.active"))
        } else{
            DEMO.postSectionStyle = 'n'
        }
    }
    sortTabs(){
        $(".post_tabs_sortable, .features_tabs_sections").sortable({
            axis: "x"
        })
        $(".post_tabs_sortable, .features_tabs_sections").sortable({
            connectWith: ".post_tabs_sortable, .features_tabs_sections",
            containment: ".post_tabs_sortable, .features_tabs_sections",
            update: function( event, ui ) {
                setTimeout(function(){
                    FEATURES.reorderPostSections()
                    ROUTER.setUrl()
                    POST.updatePostSettings()
                }, 1000)
                
            }
        }).disableSelection();
    }
    reorderPostSections(){
        var params = 'pm-'
        var length = $(".features_tabs_sections > div:not(.post-disabled)").length + $(".post_tabs_wrapper:not(.post-disabled) > div > div:not(.post-disabled)").length
        var index = 0
        var tabsParams = ""
        $(".features_tabs_sections > div:not(.post-disabled)").each(function(i){
            index++
            params += `${UCODE.psection2code[$(this).data("name")]}${length != index ? '-' : ''}`
            if($(this).data("name") == "post_tabs"){
                $(".post_tabs_sortable > div:not(.post-disabled)").each(function(d){
                    index++
                    tabsParams += `${UCODE.psection2code[$(this).data("name")]}${$(".post_tabs_wrapper:not(.post-disabled) > div > div:not(.post-disabled)").length - 1 != d ? "-" : ""}`
                    params += `${UCODE.psection2code[$(this).data("name")]}${(length != index )? '-' : ''}`
                })
                
            }
        })
        if(DEMO.showTabSection == false){
            tabsParams = 'th'
        } else if(DEMO.showTabSection == "desktop"){
            tabsParams += "-ds"
        }
        DEMO.postTabs = tabsParams
        DEMO.postSections = params
        this.setTabsSections()
        TOPBAR.changed('change_post_layout')
    }
    setTabsSections(){
        if(!DEMO.postTabs){return}
        var tabName = {
            "post_body_mobile_discovery_v1":{
                name: "Lesson Info",
                icon: "far fa-file"
            },
            "comments_discovery_v1":{
                name: "Comments",
                icon: "far fa-comment"
            },
            "post_user_notes":{
                name: "Notes",
                icon: "far fa-sticky-note"
            },
            "post_chat":{
                name: "Chat",
                icon: "far fa-comments-alt"
            },
            "post_questions":{
                name: "Questions",
                icon: "far fa-question-circle"
            },
            "post_related_posts":{
                name: "Related Lessons",
                icon: "far fa-chalkboard"
            }
        }
        $(".n_post_tabs .tabs-wrapper").html("")
        for(var tab of DEMO.postTabs.split("-")){
            if(tab == "th" || tab == "ts" || tab == "ds"){break}
            var st = `
                <div class="post-tab" data-for="${UCODE.code2psection[tab]}">
                    <span>
                        <i class="${tabName[UCODE.code2psection[tab]].icon}"></i>
                        ${tabName[UCODE.code2psection[tab]].name}
                    </span>
                </div>
            `
            $(".n_post_tabs .tabs-wrapper").append(st)
        }
        $(".n_post_tabs .tabs-wrapper > .post-tab:first-child").addClass("active")
        console.log($("#user_notes_input"))
        this.toggleTabs()
        this.addClasstoTabs()
    }
    addClasstoTabs() {
        $(".post-tab:not(.mobile_only)").each(function() {
          var sectionId = $(this).data("for")
          $(`#section-${sectionId} section`).addClass("r2-tab-data")
        })
        if ($(window).width() < 768) {
          $(".mobile_only").each(function() {
            var sectionId = $(this).data("for")
            $(`#section-${sectionId} section`).addClass("r2-tab-data")
          })
        }
      }
    toggleTabs() {
        $(".post-tab:not(.mobile_only)").each(function() {
            var sectionId = $(this).data("for")
            if ($(this).hasClass("active")) {
              $(`#section-${sectionId} section`).removeClass("tab-data-hidden").addClass("active-tab-data")
            } else {
              $(`#section-${sectionId} section`).addClass("tab-data-hidden")
            }
          })
        if(tinyMCE != undefined){
            tinyMCE.remove('#user_notes_input');
            setTimeout(function() {
                tinymce.init({
                    selector: '#user_notes_input',
                    menubar: false,
                    plugins: [
                    'link',
                    'hr'
                    ],
                    toolbar: 'undo redo | blocks | bold italic | link | forecolor backcolor | alignleft aligncenter alignright alignjustify | outdent indent | hr'
                })
            }, 3000);
        }
      }
    changeTabs($this){
        $(".feature_tabs > div").removeClass('active')
        $this.addClass("active")
        if($this.attr("value") == "disable_tabs"){
            $(".post_tabs_wrapper").after($(".post_tabs_wrapper > div > div"))
            $(".post_tabs_wrapper").addClass("post-disabled").hide()
            DEMO.showTabSection = false
        } else if($this.attr("value") == "desktop_only") {
            DEMO.showTabSection = "desktop"
        }
        else {
            $(".post_tabs_wrapper").removeClass("post-disabled").show()
            DEMO.showTabSection = true
        }

        this.reorderPostSections()
        ROUTER.setUrl()
        this.changeSections()
    }
    changeSectionStyle($this){
        var appendObj = {}
        $(".feature_posts > div").removeClass('active')
        $this.addClass("active")
        var style = `
            .post div[data-dynamic-sections] section:not([data-iname="post media discovery v1"], .post_sidebar, .n_post_tabs) {
                background: var(--bg-color-2);
                margin: 10px 15px;
            }
            .r2-tab-data {
                margin-top: 0 !important;
            }
            .r2-tab-data .sizer {
                padding: 40px 0 !important;
            }
            .r2-tab-data .row{
                padding: 0;
            }
            .tabs-wrapper {
                background: var(--bg-color-2);
            }
            .n_post_tabs .container, .n_post_tabs .sizer{
                padding: 0 !important;
            }
            .n_post_tabs{
                margin-top: 15px;
                margin-left: 15px;
                margin-right: 15px;
            }
        `
        var styleJson = `
        .post div|(data-dynamic-sections)| section:not(|(data-iname="post media discovery v1")|, .post_sidebar, .n_post_tabs) {
            background: var(--bg-color-2);
            margin: 10px 15px;
        }
        .r2-tab-data {
            margin-top: 0 !important;
        }
        .r2-tab-data .sizer {
            padding: 40px 0 !important;
        }
        .r2-tab-data .row{
            padding: 0;
        }
        .tabs-wrapper {
            background: var(--bg-color-2);
        }
        .n_post_tabs .container, .n_post_tabs .sizer{
            padding: 0 !important;
        }
        .n_post_tabs{
            margin-top: 15px;
            margin-left: 15px;
            margin-right: 15px;
        }
    `
        if($this.attr("value") == "card"){
            DEMO.postSectionStyle = "c"
            $('section[data-iname="post media discovery v1"]').append(`<style class="section_cards_style">${style}</style>`)
            appendObj = {
                "sections": { "post_media_discovery_v1": { 
                    "settings.section_style": `append|${styleJson}`} }
            }
        } else{
            $(".section_cards_style").remove()
            DEMO.postSectionStyle = "n"
        }
        LAYOUT.JTB_append(appendObj, JTB_overwrite)
        TOPBAR.changed('change_post_layout')
    }
}