console.log('layout_helpers')

JTB_baseThemeName = 'base_theme'
JTB_playlistIsBlock = false
JTB_overwrite = {}
JTB_ProgressOverwrites = {}
JTB_BadgeOverwrites = {}
JTB_TabsOverwrites = {}
JTB_outlineName = ''
JTB_outlineOverwrites = {}
JTB_playlistOverwrites = {}
JTB_playlistName = ''
JTB_headerOverwrites = {}
JTB_headerName = ''

class Layout {
    dashboardDefaultLayout() {
        this.setMainBar('main_sidebar_discovery_1')
        SIDEBARS.setSecondBar('secondary_sidebar_discovery_1')

        var appendObj = ''
        this.JTB_append(appendObj, JTB_overwrite)
        $('.background-theme-image-top').attr('style', 'display: none')
        $('.background-theme-image-bottom').attr('style', 'display: none')
        this.setThemeTypeClass('discovery')
    }

    resetJTB() {
        JTB_baseThemeName = 'base_theme'
        JTB_playlistIsBlock = false
        JTB_overwrite = {
            "setStaticSections": {},
            "sections": {}
        }
    }

    setMainBar(sectionName) {
        let text = DYNAMIC_SECTIONS.replaceBeforeAddingSection(MHTML.sections[sectionName])
        text = text.replaceAll("section-p_secondary_sidebar", "section-p_main_sidebar")
        let $newSection = $(text)
        $newSection.attr('not-dirty', 'true').attr('data-section-id', 'p_main_sidebar')
        $('.main_sidebar_wrap').html($newSection)
        JTB_overwrite.setStaticSections = {
            ...JTB_overwrite.setStaticSections,
            "p_main_sidebar": sectionName
        }
    }

    changeOutline(selectedOutline) {
        if (selectedOutline == 'Hide') {
            $(".nblock-outline").hide()
            $('.block-1637908664883').hide()
            $('.block-1645169001417').hide()
            $('.block-1637908664883').parent(".section-clmn-1").hide()
            //  add json  remove block 
            JTB_outlineOverwrites = {
                "hidden": "true"
            }
            var appendObj = ''

            if ($('.section').has('#block-1637908664883').length !== 0) {
                appendObj = {
                    "sections": {
                        "p_secondary_sidebar": {
                            "remove_block": "secondary_sidebar_evolution_1_heading",
                            "settings.clmn_style_1": "replace|/* -- Desktop Style --*/,/* -- Desktop Style --*/\nmin-height: 0;"
                        }
                    }
                }
            }

            this.JTB_append(appendObj, JTB_overwrite)
        } else {
            if (selectedOutline == "none") {
                selectedOutline = 'outline_discovery_2'
                JTB_outlineOverwrites = {
                    "progress_type": "none"
                }
            }
            $('.block-1637908664883').parent(".section-clmn-1").show()
            $('.block-1637908664883').show()
            $('.block-1645169001417').show()
            $('.nblock-outline').replaceWith(MHTML.blocks[selectedOutline])
            JTB_outlineName = selectedOutline

            $('[kjb-settings-id]').removeAttr('kjb-settings-id')
        }
        DEMO['outline_name'] = selectedOutline
    }

    setLayoutAndPlaylistToDefault() {
        JTB_ProgressOverwrites = {}
        JTB_BadgeOverwrites = {}
        JTB_TabsOverwrites = {}
        let fistVal = $('.select_outline option:nth-child(1)').attr('value')
        $('.select_outline').val(fistVal)
        JTB_outlineName = fistVal
        JTB_outlineOverwrites = {}
        fistVal = UCODE.code2playlist[SIDEBAR_SETTINGS.post.playlist]
        JTB_playlistOverwrites = {}
        JTB_playlistName = fistVal
        JTB_headerOverwrites = {}
        fistVal = UCODE.code2headers[SIDEBAR_SETTINGS.dashboard.header]
        JTB_headerName = fistVal
        fistVal = $('.select_color_mode option:nth-child(1)').attr('value')
        $('.select_color_mode').val(fistVal)
        COLORS.JTB_colorMode = 'White Mode'
        COLORS.setRgbaVars()

        $('.dynamic_styles,.progress_styles').html('')
        $('.background-theme-image-top,.background-theme-image-bottom,.main-content').attr('style', '')
        $('.background-theme-image-top .nimage,.background-theme-image-bottom .nimage').attr('src', '')
        $('body').attr('class', '')

        $('.top_padding_dashboard input').val('0')
        $('.top_padding_post input').val('0')

    }


    setContentSections(sections) {
        $('div[data-dynamic-sections]').html('')
        $('div[data-dynamic-sections]').siblings().html('')
        var cnt = 1
        var dId = ''
        var sectionRi = []
        var sectionName = ''
        for (var section of sections) {
            dId = section
            sectionName = section
            sectionRi = section.split('|')
            if (sectionRi.length > 1) {
                sectionName = sectionRi[0]
            }

            let text = MHTML.sections[sectionName]
            text = text.replace(/rykrvj3o6k/g, '42isirdu7n')
            text = text.replace(/yaron zeltzer/g, 'Jeff Lorem')
            text = text.replace(/7zaabl7v7i/g, 'c1ludijve5')

            text = text.replace('Review or reply user answers','Review or reply to user answers')
            text = text.replace('Content Management Page','Comment Management Page')
            text = text.replace('<p>Related Lessons</p>','<p>Related Lessons</p>Control which videos(lessons) are showing in the slider for each individual post, using tags and custom fields, or show automatically matched tags.')
            

            let $newSection = $(text)
            $newSection = this.replaceDynamicSectionBlockIds($newSection)
            $newSection.attr('d_id', section).attr('not-dirty', 'true')

            if (sectionName == 'post_chat'){
                var tmp_html = $newSection.html()
                tmp_html = tmp_html.replace(/element.insertAdjacentHTML/g,'//element.insertAdjacentHTML')
                $newSection.html($(tmp_html))
                
            }

            $('div[data-dynamic-sections]').append($newSection)
            if (IsR2) {
                let st = `<div class="dynamic_sections_item_wrap" d_id="` + section + `">
                <span>`+ sectionName + `</span>              
                <div class="dynamic_sections_item_icons">
                <div class="dynamic_sections_item_remove"><svg xmlns="http://www.w3.org/2000/svg" width="14.517" height="16" viewBox="0 0 14.517 16">
                <g id="Group_936" data-name="Group 936" transform="translate(-184.246 -778.25)">
                    <path id="Vector" d="M14,2.96c-1.2-.119-2.4-.208-3.6-.275V2.678l-.164-.967C10.126,1.027,9.963,0,8.222,0H6.273C4.54,0,4.376.982,4.257,1.7L4.1,2.656c-.692.045-1.384.089-2.075.156L.508,2.96a.557.557,0,1,0,.1,1.108L2.13,3.92A59.305,59.305,0,0,1,13.9,4.076h.06a.563.563,0,0,0,.558-.506A.57.57,0,0,0,14,2.96Z" transform="translate(184.246 778.25)" fill="#ff5858"/>
                    <path id="Vector-2" data-name="Vector" d="M11.01.29A.94.94,0,0,0,10.333,0H.931A.928.928,0,0,0,.254.29.958.958,0,0,0,0,.989L.463,8.621c.082,1.131.186,2.544,2.782,2.544H8.02c2.6,0,2.7-1.406,2.782-2.544L11.263,1A.964.964,0,0,0,11.01.29ZM6.867,7.438H4.39a.558.558,0,0,1,0-1.116H6.867a.558.558,0,0,1,0,1.116Zm.625-2.975H3.773a.558.558,0,1,1,0-1.116H7.492a.558.558,0,1,1,0,1.116Z" transform="translate(185.869 783.085)" fill="#ff5858"/>
                </g>
                </svg>
                </div>
                <div class="dynamic_sections_item_handle"><i class="fas fa-bars"></i></div>
                    </div>
            </div>`
                $('.dynamic_sections_wrap_inner').append(st)
            }
            cnt++
        }


        //json
        if (PAGE == HOMEPAGE) {
            var dynamicKey = "content_for_index"
        }
        if (PAGE == 'post') {
            var dynamicKey = "content_for_post"
        }
        if (PAGE == 'categories') {
            var dynamicKey = "content_for_categories"
        }
        if (PAGE == 'rsearch') {
            var dynamicKey = "content_for_search"
        }
        JTB_overwrite[dynamicKey] = sections
    }


    replaceDynamicSectionBlockIds($section) {
        var randPostfix = 99999 + Math.floor(Math.random() * 99999);
        $section.find('.nblock').each(function () {
            var blockId = $(this).attr('id')
            if ($(this).hasClass('nblock-container')) {
                return true
            }
            var newBlockId = blockId + '_' + randPostfix
            $(this).find('style').each(function () {
                var styleSt = $(this).html()
                var reBlockId = new RegExp(blockId, "g");
                styleSt = styleSt.replace(reBlockId, newBlockId)
                $(this).html(styleSt)
            })
            $(this).attr('id', newBlockId)
        })

        return $section
    }
    //



    JTB_append(appendObj, obj2overWrite) {
        this.JTBappendHelper(appendObj, obj2overWrite, "theme_settings")
        this.JTBappendHelper(appendObj, obj2overWrite, "sections")
        if (appendObj.sections == undefined) { return }
        for (var k of Object.keys(appendObj.sections)) {
            this.JTBappendHelper(appendObj.sections, obj2overWrite.sections, k)
        }
    }

    JTBappendHelper(appendObj, obj2overWrite, parentKey) {
        if (appendObj[parentKey] != undefined) {
            if (obj2overWrite[parentKey] == undefined) {
                obj2overWrite[parentKey] = appendObj[parentKey]
            } else {
                for (var childKey of Object.keys(appendObj[parentKey])) {
                    if (parentKey == 'sections' && obj2overWrite[parentKey][childKey] != undefined) { continue }
                    obj2overWrite[parentKey][childKey] = appendObj[parentKey][childKey]
                }
            }
        }
    }

    setThemeTypeClass(themeType) {
        $('.p_wrap_out').removeClass('discovery').removeClass('explorer').removeClass('curiosity').removeClass('evolution')
        $('.p_wrap_out').addClass(themeType)
        // $('.content > div > div:first-child > section').addClass('product-banner')
        if(themeType == 'curiosity' || themeType == 'evolution'){
            DEMO.dev = 'CCt'
        } else{
            DEMO.dev = 'CCf'
        }
        var appendObj =
        {
            "theme_settings":
            {
                "theme_type": themeType,
            }
        }
        this.JTB_append(appendObj, JTB_overwrite)
    }

}
