
console.log('topbar')

OUTLINE_BLOCK_IDS = []
TBAR_CHANGES = []

class Topbar{

    constructor(){
        this.isPreviewMode = false
        this.beforeChanges = {}
        this.saveState = true
        this.topbarInit()
        this.events()
    }

    topbarInit(){

        if($('body').hasClass('dark')){
            DEMO.colorMode = "d"
            $('.cb_color_mode > div').removeClass('active')
            $('.cb_color_mode > .u_right').addClass('active')
        } else{
            DEMO.colorMode = "l"
            $('.cb_color_mode > div').removeClass('active')
            $('.cb_color_mode > .u_left').addClass('active')
        }
        
        initiateSliders()
    
        $('.r3_tabs > div').hide()
        $('.r3_demos_tab').show()
        
        if(PAGE != HOMEPAGE){
            $('.r3_tab_btns >div[tab="layout"]').hide()
            $('.r3_tab_btns >div[tab="sections"]').hide()
            $('.r3_tab_btns div[tab="progress"]').hide()
        } else if(PAGE != 'post'){
            $('.r3_tab_btns >div[tab="post_layout"]').hide()
            $('.r3_tab_btns >div[tab="features"]').hide()
            $('.r3_tab_btns >div[tab="post_sections"]').hide()
            $('.more-wrapper div[tab="demos"], .more-wrapper div[tab="colors"], .more-wrapper div[tab="outline"]').hide()
            $('div[tab="postbar"]').hide()
        } 
        if(PAGE == 'post'){
            $('.r3_tab_btns >div[tab="demos"], .r3_tab_btns >div[tab="colors"], .r3_tab_btns >div[tab="outline"], .r3_tab_btns >div.sidebars-tab').hide()
            $('.r3_tab_btns >div[tab="demos"]').removeClass("active")
            $('.r3_tab_btns >div[tab="post_layout"]').addClass("active")
            $('.r3_demos_tab').hide()
            $(".r3_post_layout").show()
            $(".back_to_dashbaord").show()
        }
    }

    events(){ 
        $('.r3_tab_btns [tab]').click(function(){
            TOPBAR.tabClicked($(this))
        })

        $('.more-wrapper > div').click(function(){
            TOPBAR.moreTabClicked($(this))
        })

        $('.sidebar-dropdown > div').click(function(){
            TOPBAR.sidebarTabClicked($(this))
        })
        $('.sidebar-collection > div').click(function(){
            TOPBAR.changeSbar($(this))
        })
        $('.sidebar-dropdown > div').hover(function(){
            TOPBAR.highlightSideBar($(this))
        }, function(){
            TOPBAR.removeHighlightSidebar($(this))
        })
        $('.r3_layout_wrapper > div').click(function(){
            SIDEBARS.layoutSelected($(this))
        })
    
        $('.r3_bar_toggle').click(function(){
            TOPBAR.toggleTopbar()
        })
        $(".demos-filter input").on('click', function(){
            DEMOS.populateBrowseCompleted = false
            DEMOS.populateBrowseDemosImages(0,1000, true)
            demosSwiper.update()
        })
        $('.r3_post_wrapper > div').click(function(){
            POST.postLayoutSelected($(this).attr('post_conf'), $(this).attr('tp'))
        })
        $(".r3_post_sections_wrapper > div").click(function(){
            FEATURES.postSectionsSelected($(this).attr('post_tabs'), $(this).attr('post_sections'))
        })
        $('.r3_background_wrapper > div > div').click(function(){
            TOPBAR.changed('background')
            var name = $(this).attr('name')
            ROUTER.changeBackgroud(UCODE.code2background[name], false)
        })
        if (!IsR2){
            $('.apply_button').click(function(e){
                e.stopPropagation()
                TOPBAR.openPopBeforeApply()
            })
            $('body').on('click','.PopCannotSave_close', ()=>{
                $('.p_change_confirm_popup').remove()
                $('[data-section-id]').attr('not-dirty','true')
                this.startNotDirtyTimer()
            })
            $('body').on('click','.discard_button', ()=>{
                this.discardChanges()
            })
        }

        $('.top_padding_dashboard input').keyup(() => {
            SIDEBARS.changeContentPadding($('.top_padding_dashboard input').val())
            ROUTER.setUrl()
        })

        $('.top_padding_post input').keyup(() => {
            POST.changePostContentPadding($('.top_padding_post input').val()) 
            ROUTER.setUrl()
        })
        $('.close-sbar').click(function(){
            TOPBAR.closeSidebarWrap()
        })
        $(".sidebar_drag_wrapper").click(function(event){
            if(!$(event.target).closest('.sidebar_drag').length && !$(event.target).is('.sidebar_drag')) {
            TOPBAR.closeSidebarWrap()
            }
        })

        $(".back_to_dashbaord").click(function(){
            PAGE = 'dashboard'
            window.location.href =  ROUTER.setUrl(true)
        })

        $('body').on('mouseover','.after_install_triger',function(){
            $('.after_install_pop').show()
        })
        $('body').on('mouseleave','.after_install_triger',function(){
            $('.after_install_pop').hide()
        })
 
    }


    highlightSideBar($this){
        $('.main_sidebar_wrap').removeClass('highlight_sidebar')
        var hasMainBar = $('.p_wrap_out').hasClass('show_main_sidebar')
        var hasSecondBar = $('.sidebar').css('display') != 'none'
        $this.attr('tab')
        if(!hasMainBar){
            $this.addClass('disable-sidebar')
        }
        if(!hasSecondBar){
            $this.addClass('disable-sidebar')
        }
        if($this.attr('tab') == 'mainbar' && hasMainBar) {
            $this.removeClass('disable-sidebar')
            $('.main_sidebar_wrap').addClass('highlight_sidebar')
        } else{
            $('.main_sidebar_wrap').removeClass('highlight_sidebar')
        }

        if($this.attr('tab') == 'secondbar' && hasSecondBar){
            $this.removeClass('disable-sidebar')
            $('.sidebar').addClass('highlight_sidebar')
        } else {
            $('.sidebar').removeClass('highlight_sidebar')
        }

        if($this.attr('tab') == 'postbar'){
            $this.removeClass('disable-sidebar')
            $('.post_sidebar_section > section').addClass('highlight_sidebar')
        }
    }
    removeHighlightSidebar($this) {
        $('.sidebar').removeClass('highlight_sidebar')
        $('.main_sidebar_wrap').removeClass('highlight_sidebar')
        $('.post_sidebar_section > section').removeClass('highlight_sidebar')
    }
    moreTabClicked($this){
        $('.more_hover').attr('tab', $this.attr('tab'))
        $('.more-wrapper').hide()
        setTimeout(function (){
            $('.more-wrapper').attr('style','')
        },500)
    }
    closeSidebarWrap(){
        $('.sidebar_drag_wrapper').hide()
        $('.sidebar_drag').removeClass('open').removeClass("s-left").removeClass('left-260').removeClass("s-right").removeClass('mainbar').removeClass('secondbar').removeClass('postbar')
        TOPBAR.tabClicked($('.r3_tab_btns > div:first-child'))
    }
    sidebarTabClicked($this){
        if($this.hasClass('disable-sidebar')){return}
        sidebarSwiper.update()
        var sidebarPosition = "s-left"
        var tab = $this.attr('tab')
        var innerWidth = $('.p_wrap_out').innerWidth() / 2
        console.log(tab)
        if(tab == 'mainbar'){
            $('div[sbar="main_sidebar_discovery_1"]').show()
            var mainSidebarPosition = $('.p_outline_out').position().left
            if(innerWidth > mainSidebarPosition){
                sidebarPosition = "s-right"
            } else {
                sidebarPosition = "s-left"
            }
        } else if(tab == 'secondbar'){
            $('div[sbar="main_sidebar_discovery_1"]').hide()
            var secondBarPosition = $('.sidebar').position().left
            if(innerWidth > secondBarPosition){
                sidebarPosition = "s-right"
            } else {
                sidebarPosition = "s-left"
            }
        }
        $('.r2_topbar,.r3_topbar').css('height','49px')
        $('.p_wrap_out').css('padding-top','49px')
        $('.sidebars-tab').attr('tab', tab)
        $('.sidebar-dropdown').hide()
        setTimeout(function (){
            $('.sidebar-dropdown').attr('style','')
        },500)
        $('.sidebar_drag').removeClass("s-left").removeClass("s-right").removeClass('open').removeClass('mainbar').removeClass('secondbar').removeClass('postbar')
        $('.sidebar_drag').addClass(sidebarPosition).addClass('open').addClass(tab)
        if(IsR2){
        if(!$(".r2_sidebar").hasClass("close-r2sidebar")){
            $(".s-left").addClass("left-260")
        }
    }
        $('.sidebar_drag_wrapper').show()
        sidebarSwiper.update()
    }
    changeSbar($this){
        TOPBAR.changed('sidebars')
        var sbarFor = $('.sidebars-tab').attr('tab')
        var badgePosition;
        
        if(sbarFor == "mainbar"){
            if($this.attr('sbar') == "no_sidebar"){
                DEMO['show_main_bar'] = "f"
                DEMO.sidebars = DEMO.sidebars.replace("MSt", "MSf")
                SIDEBARS.hideMainBar()
                ROUTER.setUrl()
                return
            }
            DEMO['mainBar'] = UCODE.sidebars2code[$this.attr('sbar')]
            LAYOUT.setMainBar($this.attr('sbar'))
            badgePosition = "m"
        } else if(sbarFor == "secondbar"){
            if($this.attr('sbar') == "no_sidebar"){
                DEMO['show_second_bar'] = "f"
                DEMO.sidebars = DEMO.sidebars.replace("SSt", "SSf")
                SIDEBARS.toggleSbar("f")
                ROUTER.setUrl()
                return
            }
            DEMO['secondBar'] = UCODE.sidebars2code[$this.attr('sbar')]
            SIDEBARS.setSecondBar($this.attr('sbar'))
            badgePosition = "s"
        }
        if($this.attr('badge')){
            var badge = $this.attr('badge')
            var badgeIndex = $this.attr("badgeIndex")
            DEMO.badgeIndex = parseInt(badgeIndex)
            DEMO['badges'] = UCODE.badges2code[badge]
            DEMO.badge_position = badgePosition
            ROUTER.setUrl()
            BADGES.loadBadges()
        } else{
            DEMO['badges'] = ""
            DEMO.badge_position = ""
            ROUTER.setUrl()
        }
        
    }
    tabClicked($this){
        notific_hide()

        if ($this.hasClass('more_hover') || $this.hasClass('.sidebars-tab')){return}
        $('.r3_tab_btns > div').removeClass('active')
        $this.addClass('active')
    
        $('.r3_tabs > div').hide()
        var tab = $this.attr('tab')
        $('.r3_tabs > div[tab="'+tab+'"]').show()
        if (tab == 'demos' ){
            notific_write('Select a demo as your starting point. You will be able to change your demo at any time <span class="after_install_triger">after installing the template on your Kajabi account</span>')
        }
        else if (tab == 'outline' ){
            notific_write('Note: The top bar with all its features will be available for use inside your Kajabi account. - <span class="after_install_triger">Learn more</span>')
        }
        else if (tab == 'sections' ){
            notific_write('Select a preset to replace all your dashboard\'s dynamic sections or use the “Add Section” button on the left sidebar to add or remove single sections')
           $('.r2_topbar,.r3_topbar').css('height','248px')
           $('.p_wrap_out').css('padding-top','248px')
           setTimeout(function (){{
            sectionsSwiper.update()
        }},500)
        } else if (tab == 'progress'){
            setTimeout(function (){{
                progressSwiper.update()
            }},500)
        } else if (tab == 'badges'){
            notific_write('Control the badges, stage, images, and caption <span class="after_install_triger">after installing the template on your Kajabi account.</span> Display badges on your dashboard and end-of-lesson popups.')
            setTimeout(function (){{
                badgeSwiper.update()
            }},500)
        } else if (tab == 'background'){
            notific_write('You will be able to set your own background, top, and bottom images <span class="after_install_triger">after installing the template on your Kajabi account.</span>')
            setTimeout(function (){{
                backgroundSwiper.update()
            }},100)
        } else if(tab == "layout"){
            notific_write('Control your dashboard layout, sidebar position, content width, and document padding.')
            setTimeout(function (){{
                layoutSwiper.update()
            }},100)
        } else if(tab == "post_sections"){
            notific_write('Choose one of the presets below or use the “Sections Custom” tab for custom control.  Further control your post page features <span class="after_install_triger">after installing the template on your account.</span>')
            setTimeout(function(){
                postSectionSwiper.update()
            },100)
        } else if(tab == "post_layout"){
            notific_write('Control your post page layout, sidebar position, content width, and document padding.')
            setTimeout(function(){
                postSectionSwiper.update()
            },100)
        } else if(tab == "features"){
            notific_write('Drag sections into the tab-box to display the section in the tabs area, or out of the tab-box to display the section above or below the tabs.')
            setTimeout(function(){
                postSectionSwiper.update()
            },100)
        } else {
           $('.r2_topbar,.r3_topbar').css('height','190px')
           $('.p_wrap_out').css('padding-top','190px')
        }
    }

    
    toggleTopbar(){
        if(!IsR2){
            this.saveStateBeforeChanges()
        }

        $('.r3_topbar').css('overflow','hidden')
        if ($('.r3_bar_toggle i').hasClass('fa-caret-down')){
            this.collapseTopbar()
            if (!this.isPreviewMode){
                $('.clmn_show_grids-false').removeClass('clmn_show_grids-false').addClass('clmn_show_grids-true')
            }
        } else {
            this.OpenTopar()
        }
     }

     OpenTopar(){
        $('.clmn_show_grids-true').removeClass('clmn_show_grids-true').addClass('clmn_show_grids-false')
        this.getOutlineBlockIds()
        var barHeight = '190px'
        if ($('.r3_tab_btns div[tab="sections"]').hasClass('active')){
            barHeight = '248px'
        }
        $('.r3_bar_toggle i').removeClass('fa-caret-up')
        $('.r3_bar_toggle i').addClass('fa-caret-down')
        $('.r2_topbar, .r3_topbar').css('height',barHeight)
        $('.p_wrap_out').css('padding-top',barHeight)

        $('.toggle-sidebar').css('top','350px')
        $('.r2-toggle').css('top','300px')
       
        setTimeout(function(){
            $('.r3_topbar').css('overflow','visible')
        },200)
     }

     collapseTopbar(){
        $('.r3_topbar').css('overflow','hidden')
        $('.r3_bar_toggle i').removeClass('fa-caret-down')
        $('.r3_bar_toggle i').addClass('fa-caret-up')
        $('.r2_topbar, .r3_topbar').css('height','0px')
        $('.p_wrap_out').css('padding-top','0px')

        $('.toggle-sidebar').css('top','250px')
        $('.r2-toggle').css('top','200px')
     }

     previewModeStart(){
        this.isPreviewMode =  true
        this.trackSaveClickedOnEditor()
        this.showPreviewModeButtons()

        $('[kjb-settings-id]').removeAttr('kjb-settings-id')
     }

     trackSaveClickedOnEditor(){
        $('body').append('<div class="original_sections" style="display:none;"></div>')
        var st = ''
        $('[data-dynamic-sections] > div').each(function (){
            let sectionId =  $(this).attr('data-section-id')
            st+= `<div id="section-${sectionId}" data-section-id="${sectionId}"></div>`
        })
        $('.original_sections').append(st)
   
        $('[data-section-id]').attr('not-dirty','true')
        this.startNotDirtyTimer()
     }

     showPreviewModeButtons(){
        $('.tbar_buttons').css('bottom','0px')
     }


     startNotDirtyTimer(){
        this.NotDirtyTimer = setInterval(()=>{
            if($('[data-section-id]:not([not-dirty])').length != 0){
                this.showPopCannotSave()
                clearInterval(this.NotDirtyTimer)
            }
        },1000)
     }

     saveStateBeforeChanges(){
        if (this.saveState){
            this.saveStateSelectors = ['.main-content','#section-p_header','.p_outline_out','.color_vars','.background_images-style','.button_presets']
            for (var selector of this.saveStateSelectors){
                this.beforeChanges[selector] = $(selector)[0].outerHTML
            }

            this.beforeChanges['p_wrap_out__class'] = $('.p_wrap_out').attr('class')
            this.beforeChanges['p_wrap_out__style'] = $('.color_vars').attr('style')

            if ($('.toggle-sidebar').length == 0){
                this.beforeChanges['toggle-sidebar'] = 'remove'
            } else {
                this.beforeChanges['toggle-sidebar'] = $('.toggle-sidebar').attr('style')
            }

            this.saveState = false
        }
     }


     discardChanges(){
        //$('.clmn_show_grids-false').addClass('clmn_show_grids-true').removeClass('clmn_show_grids-false')
        $('html').attr('style','')
        $('.sidebar_styles').html('.show_only_on_postdisplay: none;}')
        $('.dynamic_styles').html('')
        $('.progress_styles').html('')
        
        this.saveStateSelectors = ['.main-content','#section-p_header','.p_outline_out','.color_vars','.background_images-style','.button_presets']
        for (var selector of this.saveStateSelectors){
            $(selector).replaceWith(this.beforeChanges[selector])
        }
        
        $('.p_wrap_out').attr('class',this.beforeChanges['p_wrap_out__class'])
        $('.p_wrap_out').attr('style',this.beforeChanges['p_wrap_out__style'])

        if (this.beforeChanges['toggle-sidebar'] == 'remove'){
            $('.toggle-sidebar').remove()
        } else {
            $('.toggle-sidebar').attr('style',this.beforeChanges['toggle-sidebar'])
        }

        this.collapseTopbar()
        $('.tbar_buttons').css('bottom','-70px')

        clearInterval(this.NotDirtyTimer)
        this.saveState = true
        this.isPreviewMode = false
        this.clearGlobals()
     }

     clearGlobals(){
        TBAR_CHANGES = []
        DEMO = {}
        SIDEBAR_SETTINGS = {}
        JTB_playlistIsBlock = false
        JTB_overwrite = {}
        JTB_ProgressOverwrites = {}
        JTB_BadgeOverwrites = {}
        JTB_outlineName = ''
        JTB_outlineOverwrites = {}
        JTB_playlistOverwrites = {}
        JTB_playlistName = ''
        JTB_postSections = {}
        JTB_headerOverwrites = {}
        JTB_headerName = ''

        BAP.sidebars_defaults()
     }

     showPopCannotSave(){
        var popup = `
        <div class='p_change_confirm_popup'>
          <div class='p_change_confirm_wrap PopCannotSave'>
            <div class='p_change_confirm_text'>
              <h3>Cannot apply changes</h3>
              <p>Cannot apply any changes using the sidebar while in Preview Mode</p>
              <p>To exit Preview Mode click Apply Changes or Discard Changes below</p>
            </div>
            <div class='p_change_confirm_buttons'>
                <button class='PopCannotSave_close'><span>Close</span></button>
            </div>
          </div>
        </div>
      `
      $('body').append(popup)
     }



     permantLostMessage(){
        var msg = [];
        if (TBAR_CHANGES.includes('change_layout')){
            msg.push('Template Sidebars (Partial Loss)')
        }    
        if (TBAR_CHANGES.includes('change_post_layout')){
            msg.push('Some of the Template Sidebars (Partial Loss)')
        }  
        if (TBAR_CHANGES.includes('change_post_sections')){
            msg.push('All Post Page Dynamic Sections')
        } 
        if (TBAR_CHANGES.includes('outline')){
            msg.push('Outline Block')
        } 
        if (TBAR_CHANGES.includes('colors')){
            msg.push('Template Colors')
        } 
        if (TBAR_CHANGES.includes('dynamic_sections')){
            msg.push('All Dynamic Sections')
        } 
        if(TBAR_CHANGES.includes('header')){
            msg.push('Header')
        }
        if(TBAR_CHANGES.includes('progress')){
            msg.push('Progress Block')
        }
        if(TBAR_CHANGES.includes('badges')){
            msg.push('Badges')
        }
        if(TBAR_CHANGES.includes('background')){
            msg.push('Template Background')
        }
        if(TBAR_CHANGES.includes('sidebars')){
            msg.push('Template Sidebars (Partial Loss)')
        }
        if (TBAR_CHANGES.includes('demo')){
            msg = [];
            msg.push('<b>ALL</b> PREVIOUS CUSTOMIZATION WILL BE LOST')
        }
        this.LOST_MSG = ''
        for (row of msg){
            this.LOST_MSG += '<li style="line-height: 2;">'+row+'</li>'
        }
     }
     
     
     openPopBeforeApply(){
        this.permantLostMessage()
        var popup = `
        <div class='p_change_confirm_popup'>
          <div class='p_change_confirm_wrap'>
            <div class='p_change_confirm_text'>
              <h3>Are You Sure?</h3>
              <p>You are about to overwrite some of your template settings.</p>
              <p class="lma_p" style="margin-top: -10px; margin-bottom: 29px;">You will not be able to undo those changes.</p>
              <p class="lma_u" style="margin-top: -8px;font-weight: 700;">Any changes made to the components listed below will be permanently lost:</p>
              <ul style="margin-left: 16px;">
                ${this.LOST_MSG}
              </ul>
            </div>
            <div class='p_change_confirm_buttons'>
                <button class='p_cancel_confirm'><span>No</span></button>
                <button class='p_confirm_change'><span>Yes</span></button>
            </div>
          </div>
        </div>
      `
      $('body').append(popup)
      $('body').on('click','.p_cancel_confirm', function(){
        $('.p_change_confirm_popup').hide()
        $('.p_cancel_confirm').off('click')
        $('.p_confirm_change').off('click')
        return false
      })
      $('body').on('click','.p_confirm_change', function(){
        $('.p_change_confirm_popup').hide()
        $('.p_change-template').hide()
        TOPBAR.applyChanges()
        
      })
     }
    

    applyChanges(){
        var payloads = {}
        if (TBAR_CHANGES.includes('demo')){
            payloads= this.bapChangeDemo(payloads)
        } else {
            if (TBAR_CHANGES.includes('change_layout')){
                payloads = this.bapChangeLayout(payloads)
            }    
            if (TBAR_CHANGES.includes('change_post_layout')){
                payloads = this.bapChangePostLayout(payloads)
            }  
            if (TBAR_CHANGES.includes('change_post_sections')){
                payloads = this.bapChangePostSections(payloads)
            } 
            if (TBAR_CHANGES.includes('outline')){
                payloads = this.bapChangeOutline(payloads)
            } 
            if (TBAR_CHANGES.includes('colors')){
                payloads = this.bapChangeColors(payloads)
            } 
            if (TBAR_CHANGES.includes('dynamic_sections')){
                payloads = this.bapChangeDynamicDections(payloads)
            } 
            if(TBAR_CHANGES.includes('header')){
                payloads = this.bapChangeHeader(payloads)
            }
            if(TBAR_CHANGES.includes('progress')){
                payloads = this.bapChangeProgress(payloads)
            }
            if(TBAR_CHANGES.includes('badges')){
                payloads = this.bapChangeBadges(payloads)
            }
            if(TBAR_CHANGES.includes('background')){
                payloads = this.bapChangeBackground(payloads)
            }
            if(TBAR_CHANGES.includes('sidebars')){
                payloads = this.bapChangeSidebars(payloads)
            }
        }
        
        $('#payload').val(JSON.stringify(payloads))
        $('#payload_flag').val(Math.floor(Math.random() * 99999999999))
    }
    
    bapChangeDemo(payloads){
        console.log(JTB_overwrite)
        var settingsDataSt = BUILD.bapBuildClicked()
        var settingsData = JSON.parse(settingsDataSt)
        var obj = {
            settingsData:settingsData,
        }
        payloads['demo'] = obj
        console.log(payloads)
        return payloads
    
    }
    
    bapChangeOutline(payloads){
        var obj = {
            outline:DEMO['outline'],
            blockIds:OUTLINE_BLOCK_IDS,
            outline_overwrite: JTB_outlineOverwrites
        }
        payloads['outline'] = obj
        return payloads
    }
    
    getOutlineBlockIds(){
        $('.nblock-outline').each(function (){
            OUTLINE_BLOCK_IDS.push($(this).attr('id').replace('block-',''))
        })
    }
    
    bapChangeColors(payloads){
        var obj = {
            "color-mode":DEMO['colorMode'],
            "colors":DEMO['colors']
        }
        payloads['colors'] = obj
        return payloads
    }

    bapChangeHeader(payloads){
        var obj = {
            "header": UCODE.code2headers[DEMO["header"]],
            "top_padding": DEMO["contentTopPadding"]
        }
        payloads['headers'] = obj
        return payloads
    }
    bapChangeProgress(payloads){
        var obj = {
            "progress": DEMO.progress,
            "overwrite": JTB_ProgressOverwrites,
            "sidebar": DEMO.progress_sidebar
        }
        payloads['progress'] = obj
        console.log(payloads)
        return payloads
    }
    bapChangeBadges(payloads){
        var obj = {
            "badges": JTB_overwrite,
            "overwrite": JTB_BadgeOverwrites,
            "sidebar": DEMO.badge_position_name
        }
        payloads['badges'] = obj
        console.log(payloads)
        return payloads
    }
    bapChangeBackground(payloads){
        var obj = {
            "background": DEMO['background'],
            "overwrite": JTB_overwrite
        }
        payloads['background'] = obj
        console.log(payloads)
        return payloads
    }
    bapChangeSidebars(payloads){
        var obj = {
            "sidebars": JTB_overwrite
        }
        payloads['sidebars'] = obj
        console.log(payloads)
        return payloads
    }
    bapChangeDynamicDections(payloads){
        var obj = {
            "dynamicSections":DEMO['sections']
        }
        payloads['dynamicSections'] = obj
        return payloads
    }
    
    bapChangeLayout(payloads){
        var obj = {
            "changeLayout":JTB_overwrite
        }
        payloads['changeLayout'] = obj
        return payloads
    }
    
    bapChangePostLayout(payloads){
        var obj = {
            "changePostLayout":JTB_overwrite,
            "playlist_name": JTB_playlistName,
            "playlistIsBlock": JTB_playlistIsBlock
        }
        payloads['changePostLayout'] = obj
        console.log(payloads)
        return payloads
    }
    bapChangePostSections(payloads){
        var obj = {
            "sections": DEMO["post_sections"],
        }
        payloads["changePostSections"] = obj
        console.log(payloads)
        return payloads
    }
    changed(type){
        if(!IsR2){
            if (TBAR_CHANGES.length == 0){
                this.previewModeStart()
            }
            if (!TBAR_CHANGES.includes(type)){
                TBAR_CHANGES.push(type)
            }
        }
    }

    
    

}
