$(document).ready(function(){

    var url_r = window.location.href.split('/')
    CURRENT_VIDEO = url_r[url_r.length-1]
    if (CURRENT_VIDEO == '' || CURRENT_VIDEO == '#'){
        CURRENT_VIDEO = url_r[url_r.length-2]
    }
    CURRENT_VIDEO = CURRENT_VIDEO.replace(/_/g,' ').replace('#','')
    if (POSTS[CURRENT_VIDEO] == undefined){
        window.location.href = '/resources/'+WITH_or_no_header+'/Page_Templates'
    } 

    if (PAGE == 'index'){
        index_onLoad()
    }

    if (PAGE == 'post'){
        post_onLoad()
        index_onLoad()
    }

})


POST_wrap_html = $('.post_wrap')[0].outerHTML
function index_onLoad(){
  
    $('.posts_wrap').html('')

    for (post_name of Object.keys(POSTS)){
        $post_wrap = create_post_block(POSTS[post_name],POST_wrap_html)
        $('.posts_wrap').append($post_wrap)
    }
}

function create_post_block(post,POST_wrap_html){

    var $post_wrap = $(POST_wrap_html)
    $post_wrap.find('.post_title').html(post.title)

    $post_wrap.find('.post_text').html(post.text)
    $post_wrap.find('.post_duration span').html(post.duration)
    $post_wrap.find('.post_series').html(post.series)
    $post_wrap.find('.post_author_name').html(post.author)

    var href =  '/resources/'+WITH_or_no_header+'/' + post.title.replace(/ /g,'_')
    if (post.author == 'Kajabi'){
        $post_wrap.find('.post_author_img img').attr('src','/site/images/kajabi_logo.png')
        href = post.video
        $post_wrap.attr('target','_blank')
    }

    $post_wrap.attr('href',href)
    
    return $post_wrap  
}


function post_onLoad(){
    
    $('.post_below_title').html(POSTS[CURRENT_VIDEO].title)
    $('.post_below_text').html(POSTS[CURRENT_VIDEO].text)

    intiate_video(POSTS[CURRENT_VIDEO].video,POSTS[CURRENT_VIDEO].thumb)
    post_page_side_posts()

    $('.post_page_loading').removeClass('post_page_loading')

    if (POSTS[CURRENT_VIDEO].title == 'Icons'){
        $('.post_below_text').append('<br><a class="kcenter_fov5" href="https://fontawesome.com/v5/search" target="_blank">https://fontawesome.com/v5/search</a>')
    }
}

VIDEOS_loaded = []
function intiate_video(video_id,thumbnail){
    thumbnail = '/site/resources/images/'+thumbnail
    var video_code =  '<div id="wistia_'+video_id+'" class="wistia_embed wistia_async_'+video_id+'">&nbsp;</div>';
    $('.kjb-video-responsive').html(video_code)
    window._wq = window._wq || [];
    _wq.push({
        id:video_id,
        options:{playerColor:"#1a62ca",stillUrl:thumbnail,autoPlay:false,playButton:false},
        onReady: function(video) {
            video.bind("end", play_next_video_callback);
            
    }});
}

function play_next_video($next_vid){
    var next_vid_title = $next_vid.find('.post_title').text()
    $('.post_page_sidebar .post_wrap').removeClass('active')
    $next_vid.addClass('active')
    var id = POSTS[next_vid_title].video
    var thumb = '/site/resources/images/' + POSTS[next_vid_title].thumb

    var video = Wistia.api(POSTS[CURRENT_VIDEO].video)

    //video.unbind("end", play_next_video_callback);

    video.replaceWith(id,{transition: "slide",playerColor:"#1a62ca",stillUrl:thumb,autoPlay:false,playButton:false});

    PREV_VIDEO = video
    CURRENT_VIDEO = next_vid_title

    play_next_video_change_text()
    
    setTimeout(function(){
        PREV_VIDEO.unbind("end", play_next_video_callback);
        video = Wistia.api(POSTS[CURRENT_VIDEO].video)
        video.play()
        video.bind("end", play_next_video_callback);
    },2000)
}

function play_next_video_change_text(){
    $('.post_below_title').html(POSTS[CURRENT_VIDEO].title)
    $('.post_below_text').html(POSTS[CURRENT_VIDEO].text)
    if (POSTS[CURRENT_VIDEO].title == 'Icons'){
        $('.post_below_text').append('<br><a class="kcenter_fov5" href="https://fontawesome.com/v5/search" target="_blank">https://fontawesome.com/v5/search</a>')
    }
}


var play_next_video_callback = function() {
    play_next_video($('.post_wrap.active').next())
};

function post_page_side_posts(){
    var playlist_name = POSTS[CURRENT_VIDEO].playlist
    var playlist_videos = PLAYLISTS[playlist_name]
    playlist_videos = playlist_videos.concat(PLAYLISTS.default)
    playlist_videos.unshift(CURRENT_VIDEO)
    
    $('.post_page_sidebar_inner').html('')
    var i = 0
    for (post_name of playlist_videos){
        if (post_name == CURRENT_VIDEO && i != 0){ continue }
        $post_wrap = create_post_block(POSTS[post_name],POST_wrap_html)
        if (i == 0){
            $post_wrap.addClass('active')
        }
        $('.post_page_sidebar_inner').append($post_wrap)
        i++
    }
}


$('.posts_search').keyup(function(e){
    search_posts()
})

function search_posts(){
    $('.posts_wrap').html('')

    var search_term = $('.posts_search').val().toLowerCase()
    for (post_name of Object.keys(POSTS)){
        var post = POSTS[post_name]
        let st = post.title +' '+ post.text
        if (!st.toLowerCase().includes(search_term)) { continue }
        $post_wrap = create_post_block(post,POST_wrap_html)
        $('.posts_wrap').append($post_wrap)
    }
}


$('.provide_feedback_wrap').click(function (e){
    $('.feedback_wrap').css('display','flex')
    setTimeout(function (){
        $('.feedback_wrap').css('transform','translatex(0px)')
    },200)
   
})


$('.feedback_input_button').click(function(){
    data = {
        action:'feedback',
        message: $('.feedback_input textarea').val()
    }
    $.post( "/API/email.php",data, function( res ) {});

   $('.feedback_input textarea').val('')
   $('.feedback_success').show(200);
   setTimeout(()=>{
    $('.feedback_success').hide(200);
   },3000)

});

$('body').on('click','.post_page_sidebar .post_wrap', function(e){
    e.preventDefault()  
    $('.post_page_sidebar .post_wrap').removeClass('active')
    $(this).addClass('active')
    play_next_video($(this))
})


$('.posts_tags_wrap span').click(function (e){
    $('.posts_search').val($(this).text())
    search_posts()
})

$('.posts_clear_search').click(function (e){
    $('.posts_search').val('')
    search_posts()
})

