API_PATH = '/API/'
LOGIN_THEN_SAVE = false;
$('.reg_button').click(function (){
    $('.login_error').hide()
    $('.reg_error').hide()

    var is_valid = true;
    let email = $('.regi_email input').val()
    let pass = $('.regi_pass input').val()

    if (!validateEmail(email)){
        $('.reg_email_error').show()
        is_valid = false
    }

    if (pass.length < 6){
        $('.reg_pass_error').show()
        $('.reg_pass_error').html('At least 6 characters')
        is_valid = false
    }

    if (is_valid){
        submit_register(email,pass)
    }
    

})

function submit_register(email,pass){
    let data = {
        action:'register',
        email:email,
        pass:pass
    }
    $.post(API_PATH + 'login.php',data,function(res){
        var res_json = JSON.parse(res)
        console.log(res_json)
        if (res_json.msg == 'Email already taken'){
            $('.reg_error').html('Email already taken')
            $('.reg_error').show()
        } else if(res_json.msg == 'Account Created'){
            proccess_login(email,res_json.token,res_json.stat)
        } else {
            $('.reg_error').html('Error Creating Account')
            $('.reg_error').show()
            $('.login_button_pressed').removeClass('login_button_pressed')
        }
    })
}


USER = {};
USER.logedin = false;
USER.email = '';
USER.refferer = '';

USER.token = getCookie('token')
if (USER.token != ''){
    USER.logedin = true;
    USER.email = getCookie('email')
}




function proccess_login(email,token,stat,gen){
    USER.logedin  = true;
    USER.email = email;
    USER.token = token;
    USER.stat = stat;
    USER.gen = gen;

    $('body').addClass('gen_'+gen)

    if (typeof(LOGIN_THEN_DOWNLOAD) == 'undefined'){
        LOGIN_THEN_DOWNLOAD = false
    }

    document.cookie = 'email='+email+'; expires=Thu, 18 Dec 2025 12:00:00 UTC; path=/';
    document.cookie = 'token='+token+'; expires=Thu, 18 Dec 2025 12:00:00 UTC; path=/';
    if (USER.refferer == ''){
        if (LOGIN_THEN_SAVE){
            $('.te_login_btn').hide()
            $('.te_logout_btn').show()
            if (is_BAP){
                account_page_hide('login');
                sidebar_block_show('save')
            } else {
                account_page_hide('demos');
                save_btn_clicked()
            }
            LOGIN_THEN_SAVE = false;
        } else if (LOGIN_THEN_DOWNLOAD){
            $('.te_login_btn').hide()
            $('.te_logout_btn').show()
            show_download_page()
            LOGIN_THEN_DOWNLOAD = false
        } else if (typeof(IS_PRE_PAYMENT) != 'undefined'){
            $('.checkout_login').hide()
            $('.checkout_payment_buttons').show()
            $('.field-wrapper').removeClass('login')
            $('.provided_email').html(USER.email)
        } else {
            window.location.replace("/account/my-themes");
        }
        
    }

}

function validateEmail(email){
    return String(email)
      .toLowerCase()
      .match(
        /^(([^<>()[\]\\.,;:\s@"]+(\.[^<>()[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/
      );
};


$('.already_have_account').click(function (){
    $('.register_box').hide()
    $('.login_box').show()
})
$('.do_not_have_account').click(function (){
    $('.register_box').show()
    $('.login_box').hide()
})


$('.login_button').click(function (){
    let email = $('.login_email input').val()
    let pass = $('.login_pass input').val()
    submit_login(email,pass)
})


function submit_login(email,pass){
    console.log('loginbtn')
    $('.login_error').hide()

    let data = {
        action:'login',
        email:email,
        pass:pass
    }
    $.post(API_PATH + 'login.php',data,function(res){
        var res_json = JSON.parse(res)
        if (res_json.msg == 'Login successfully'){
            proccess_login(email,res_json.token,res_json.stat,res_json.gen)
        } else {
            $('.login_error').show()
            $('.login_error').html('Invalid Login Details')
            $('.login_button').removeClass('login_button_pressed')
        }
    })
}


$('.te_logout_btn').click(function (){
    USER.logedin  = false;
    document.cookie = 'email=; Max-Age=0; path=/';
    document.cookie = 'token=; Max-Age=0; path=/';
    window.location.replace("/themes/kyoto");
})


$('.show_forgot_password').click(function (){
    $('.forgot_box1').show()
    $('.login_box').hide()
})

$('.recover_pass_button').click(function (){
    request_recovery($('.recovery_email input').val())
})

function request_recovery(email){
    $('.forgot_box1').html('<div class="new_pass_confirm">Check your email</div>')

    let data = {
        action:'recover',
        email:email
    }
    $.post(API_PATH + 'login.php',data,function(res){
        
    })
}

console.log('login.js')
$('.te_login_btn').click(function(){
    
    login_btn_clicked()
    sidebar_item_set_active($(this))
});
function login_btn_clicked(){
    $('.login_wrap').removeClass('hide-true').removeClass('show-true')
    $('.login_wrap').hide()
    $('.login_box').show()
    $('.r2_sidebar').addClass('with_account_page')
    
    account_page_show('login')
}


$('.recover_create_new_pass').click(function (){
    let urlParams = new URLSearchParams(window.location.search);
    let email = urlParams.get('email')
    let token = urlParams.get('token')
    create_new_password(email,token)
})
function create_new_password(email,token){
    $('.login_error').hide()

    var is_valid = true;
    var new_pass = $('.new_pass input').val()
    var new_pass_confirm = $('.new_pass_confirm input').val()


    if (new_pass.length < 6){
        $('.new_pass_error').show()
        $('.new_pass_error').html('At least 6 characters')
        is_valid = false
    }

    if (new_pass !=  new_pass_confirm){
        $('.new_pass_confirm_error').show()
        $('.new_pass_confirm_error').html('Passwords do not match')
        is_valid = false
    }


    if (is_valid){
        let data = {
            action:'new password',
            email:email,
            new_pass:new_pass,
            token:token
        }
        $.post(API_PATH + 'login.php',data,function(res){
            $('.forgot_box_create').html('<div class="new_pass_confirm">You have successfully reset your password</div>')
            setTimeout(function (){
               window.location.replace("account/login");
            },4000)
        })
    }


}

function getCookie(cname) {
    let name = cname + "=";
    let decodedCookie = decodeURIComponent(document.cookie);
    let ca = decodedCookie.split(';');
    for(let i = 0; i <ca.length; i++) {
      let c = ca[i];
      while (c.charAt(0) == ' ') {
        c = c.substring(1);
      }
      if (c.indexOf(name) == 0) {
        return c.substring(name.length, c.length);
      }
    }
    return "";
  }



  $('.login_page .account_close_btn').click(function(){
    let block_name = $(this).closest('.account_page').data('block-name')
    account_page_hide(block_name)
 });