<?php

$default_demo_sections_st = file_get_contents('parts/default_demo_sections.json');
$GLOBALS['demo_sections'] =  json_decode($default_demo_sections_st,true);

$inner_pages = file_get_contents('../../themes/includes/inner_pages/inner_pages_sections.json');
$GLOBALS['inner_pages'] =  json_decode($inner_pages,true);

$demos_heros_and_bottoms = file_get_contents('../../themes/includes/inner_pages/inner_pages_theme_info.json');
$GLOBALS['heros_and_bottoms'] =  json_decode($demos_heros_and_bottoms,true);

$encore_setting_data = get_setting_date_from_zip();

    
$enc_setting = json_decode($encore_setting_data, true);
$enc_current = $enc_setting["current"];

$primary_color = $enc_current["color_primary"];
$font_body = $enc_current["font_family_body"];
$color_body = $enc_current["color_body"];
$page_bg_color = $enc_current["background_color"];
$font_heading = $enc_current["font_family_heading"];
$button_bg = $enc_current["btn_background_color"];
$button_color = $enc_current["btn_text_color"];
$button_radius = $enc_current["btn_border_radius"];
$btn_style = $enc_current["btn_style"];

if(empty($page_bg_color)){
    $page_bg_color = "#ffffff";
}

$enc_current = set_login_as_dynamic($enc_setting, $enc_current);


$accent_2 = "";
if(strpos($primary_color, "(")){
    $accent_2 = rgb_to_hex( $primary_color );
    $accent_2 = adjustBrightness($accent_2, 40);
} else {
    $accent_2 = adjustBrightness($primary_color, 40);
}
if($btn_style == "outline") {
    $enc_current["p1_cta_outline"] = "true";
    $button_color = $button_bg;
}
$enc_current["paste_css"] = $enc_current["css"];
$enc_current["accent_1"] = $primary_color;
$enc_current["accent_2"] = $accent_2;
$enc_current["light_1"] = $page_bg_color;
$enc_current["light_2"] = "#f2f2f2";
$enc_current["dark_1"] = "#010101";
$enc_current["dark_2"] = "#333333";
$enc_current["text_color_dark"] = "#f2f2f2";
$enc_current["p1_cta_bg_color"] = $button_bg;
$enc_current["p1_cta_color"] = $button_color;
$enc_current["landing_pages_hero"] = "Kyoto - Hero";
$enc_current["inner_pages_hero"] = "Kyoto - Inner Hero";
$enc_current["inner_pages_bottom"] = "Kyoto - Newsletter,Kyoto - Blog";
$enc_current["p1_cta_border_radius"] = $button_radius . "px";
$enc_current["p2_cta_border_width"] = "2px";
$enc_current["license_key"] = "908a87c9ging1h24bee31";
$enc_current["css"] = "/*-- Custom Selectors --*/\n[Heading]\n.heading {\nmargin-bottom: 20px;\n}\n.heading * {\nfont-size: 36px;\nfont-weight: 400;\nline-height: 1.3;\ntext-transform: capitalize;\nmargin-top:0;\n}\n[Pre Heading]\n.pre-heading * {\nfont-size:16px;\nmargin-bottom:0;\n}\n.pre-heading {\nmargin-bottom: 10px;\n}\n[Sub Heading]\n.sub-heading {\nmargin-bottom:10px;\n}\n.sub-heading * {\nfont-size:20px;\ncolor:var(--accent-2);\n}\n/*-- Ignore --*/\n@media (max-width:767px){\n.heading * {font-size:28px;}\n}\n";

include "./shared/set_page_sections.php";

$enc_current = set_page_sections_robust($enc_current,'inner-upsilon','inner_page_1');
$enc_current = set_page_sections_robust($enc_current,'inner-tau','inner_page_2');
$enc_current = set_page_sections_robust($enc_current,'inner-iota','inner_page_3');

$enc_current = set_page_sections_robust($enc_current,'osaka','landing_page_1');
$enc_current = set_page_sections_robust($enc_current,'taipei','landing_page_2');
$enc_current = set_page_sections_robust($enc_current,'kyoto','landing_page_3');

$enc_current = set_page_sections_robust($enc_current,'product-outline-2','product_info');
$enc_current = set_page_sections_robust($enc_current,'inner-kappa','about');
$enc_current = set_page_sections_robust($enc_current,'contact-1','contact');
$enc_current = set_page_sections_robust($enc_current,'podcast-section','podcasts');
$enc_current = set_page_sections_robust($enc_current,'Store-custom','offers_page');
$enc_current = set_page_sections_robust($enc_current,'pricing-1','pricing');
$enc_current = set_page_sections_robust($enc_current,'events-2','events');
$enc_current = set_page_sections_robust($enc_current,'testimonials-3','testimonials');
$enc_current = set_page_sections_robust($enc_current,'video-testimonials-1','video_testimonials');
$enc_current = set_page_sections_robust($enc_current,'faq-1','faq');
$enc_current = set_page_sections_robust($enc_current,'gallery-masonary','gallery');
$enc_current = set_page_sections_robust($enc_current,'timeline-a','timeline');

function set_login_as_dynamic($enc_setting, $enc_current) {
    if(isset($enc_setting["current"]["sections"]["login"])) {
    $login_section = $enc_setting["current"]["sections"]["login"];
    } else {
    $login_section = json_decode(get_login_if_no_login_data(), true);
    }
    $login_section_name = strval(rand(1000000000, 9999999999));
    echo $login_section_name;
    // $new_settings = json_decode($new_settings_data, true);
    $enc_current["content_for_login"] = [$login_section_name];
    $enc_current["sections"][$login_section_name] = $login_section;
    return $enc_current;

}


put_settings_data($enc_setting, $enc_current);


function get_setting_date_from_zip(){
    
    $encore_setting_data = file_get_contents("./encore_settings/settings_data_hopper.json");
    return  $encore_setting_data; 
}
function get_login_if_no_login_data(){
    
    $login_data = file_get_contents("./login.json");
    return  $login_data;
}
function put_settings_data($enc_setting, $enc_current){
    $enc_setting["current"] = array_merge($enc_setting["current"], $enc_current);
    $new_settings_data = json_encode($enc_setting);
    file_put_contents('./encore_settings_out/settings_data.json', $new_settings_data);
}

function adjustBrightness($hex, $steps) {
    // Steps should be between -255 and 255. Negative = darker, positive = lighter
    $steps = max(-255, min(255, $steps));

    // Normalize into a six character long hex string
    $hex = str_replace('#', '', $hex);
    if (strlen($hex) == 3) {
        $hex = str_repeat(substr($hex,0,1), 2).str_repeat(substr($hex,1,1), 2).str_repeat(substr($hex,2,1), 2);
    }

    // Split into three parts: R, G and B
    $color_parts = str_split($hex, 2);
    $return = '#';

    foreach ($color_parts as $color) {
        $color   = hexdec($color); // Convert to decimal
        $color   = max(0,min(255,$color + $steps)); // Adjust color
        $return .= str_pad(dechex($color), 2, '0', STR_PAD_LEFT); // Make two char hex code
    }

    return $return;
}

function rgb_to_hex( $rgba ){
    if ( strpos( $rgba, '#' ) === 0 ) {
        return $rgba;
    }

    preg_match( '/^rgba?[\s+]?\([\s+]?(\d+)[\s+]?,[\s+]?(\d+)[\s+]?,[\s+]?(\d+)[\s+]?/i', $rgba, $by_color );

    return sprintf( '#%02x%02x%02x', $by_color[1], $by_color[2], $by_color[3] );
}

function set_page_sections_robust($empty_conf,$page_type,$page_file_name){
    
    $page_name = $page_type;
    if (isset($_POST[$page_type] )){
        $page_name = ucfirst(strtolower(str_replace(' ','-',$_POST[$page_type])));
    }

    $demo_lcase = "kyoto";
    
    $sections_r = [];
    foreach ($GLOBALS['inner_pages'][$page_name] as $section_name){
        if ($section_name == '*hero'){
            $section_name =  $GLOBALS['heros_and_bottoms'][$demo_lcase]['hero'];
        }

        if ($section_name == '*inner-hero'){
            $section_name = $GLOBALS['heros_and_bottoms'][$demo_lcase]['inner-hero'];
        }
        if ($section_name == '*bottom'){
           $bottom_sections = $GLOBALS['heros_and_bottoms'][$demo_lcase]['bottom'];
           foreach ($bottom_sections as $bottom_section){
                array_push($sections_r,$bottom_section);
           }
           continue;
        }

        $lsection = strtolower($section_name);
        if(strpos($lsection , 'header') == false && strpos($lsection , 'footer') == false){
            array_push($sections_r,$section_name);
        }

    }

    if ($page_file_name != ''){
        $page_type = $page_file_name;
    }
    
    $empty_conf = add_sections($empty_conf,$sections_r,'content_for_' . $page_type);
    return $empty_conf;
}

// function add_sections($empty_conf,$sections_r,$content_for_str){
    
//     $empty_conf["current"][$content_for_str] = [];
//     foreach ($sections_r as $this_section_name){
//         if ($this_section_name == ''){continue;}
//         $file_name = str_replace(' ','_',$this_section_name);
//         if (strpos(strtolower($file_name), 'sidebar_bottom') !== false) { 
//             $res = json_decode('{"section_object":{ "654365465":{"type": "sidebar_bottom","hidden": "false","name": "Bottom Sidebar"}},"section_id":"654365465"}',true);
//         } else {
//             if (!file_exists('parts/sections_presets/'. $file_name .'.json')){
//                 echo 'ERROR - connot find file ' . $file_name . ' in function add_sections';
//                 continue;
//             }
//             $section_preset_st = file_get_contents('parts/sections_presets/'. $file_name .'.json');
//             $section_preset = json_decode($section_preset_st,true);
//             $res = section_prests_2_proper_format($section_preset);
//         }

//         if($content_for_str == 'content_for_index'){
//             $res['section_object'][$res['section_id']]['settings']['kjbid'] = rand(1000,9900) . rand(1001,2999);
//         }

//         $empty_conf["current"]["sections"][$res['section_id']] = $res['section_object'][$res['section_id']];

//         if ($res['section_id'] == 'pop_exit'){
//             $res['section_object'][$res['section_id']]['type'] = "pop_two_step";
//             $empty_conf["current"]["sections"]['pop_two_step'] = $res['section_object'][$res['section_id']];
//         }
    
//         if (!in_array($res['section_id'],['header','footer','pop_exit'])){
//             array_push($empty_conf["current"][$content_for_str],$res['section_id']);
//         }

//     }
//     return $empty_conf;
// }

// function section_prests_2_proper_format($section_preset){
//     $section_settings = [];
//     $block_order = [];
//     $new_blocks = [];
//     foreach ($section_preset["blocks"] as $block){
//         $block_id = strval(rand(1000000000, 9999999999));
//         array_push($block_order,$block_id);
//         if (empty($block['settings'])){
//             unset($block['settings']);
//         }
//         $new_blocks[$block_id] = $block;
    
//     }
    
//     $section_settings["blocks"] = $new_blocks;
//     $section_settings["block_order"] = $block_order;
//     $section_settings["settings"] = $section_preset["settings"];
    
//     $section_settings["type"] = $section_preset["type"];
//     $section_settings["name"] = $section_preset["name"];
//     $section_settings["hidden"] = 'false';
  
    
//     $section_id = strval(rand(1000000000, 9999999999));
//     if (in_array($section_preset["type"],['header','footer','pop_exit'])){
//         $section_id= $section_preset["type"];
//     }

//     $section_wrap = [];
//     $section_wrap[$section_id] = $section_settings;


//     $res = [];
//     $res['section_object'] = $section_wrap;
//     $res['section_id'] = $section_id;

//     return $res;
// }